<?php
session_start();

// CONFIGURACIÓN
$TIEMPO_INACTIVIDAD = 900; // 15 minutos

function destruir_sesion_y_redirigir($motivo = '') {
    session_unset();
    session_destroy();
    //$url = '../index.php';
    $redireccion = 'views/pages/error_sesion.php';

    if ($motivo !== '') {
        $url .= '?motivo=' . urlencode($motivo);
    }
    header("Location: $url");
    exit;
}

// 1. Validar existencia de sesión
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
    destruir_sesion_y_redirigir('no_autorizado');
}

// 2. Validar expiración por inactividad
if (!isset($_SESSION['ultimo_movimiento']) || time() - $_SESSION['ultimo_movimiento'] > $TIEMPO_INACTIVIDAD) {
    destruir_sesion_y_redirigir('expirado');
}
$_SESSION['ultimo_movimiento'] = time(); // actualizar tiempo activo

// 3. Verificar IP y navegador
if (
    !isset($_SESSION['ip_cliente']) || $_SESSION['ip_cliente'] !== $_SERVER['REMOTE_ADDR'] ||
    !isset($_SESSION['user_agent']) || $_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT']
) {
    destruir_sesion_y_redirigir('secuestro_detectado');
}

// 4. Generar token CSRF si no existe
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
