<?php    
include ("../conex.php");
session_start();

$id_usuario = $_SESSION['idusuario'];
$idsp = $_SESSION['idsp'];

date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y/m/d');
$time_actual = date("H:i:s");
$my_ip = $_SERVER["REMOTE_ADDR"];

include "qrlib.php";    

$PNG_TEMP_DIR = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'temp' . DIRECTORY_SEPARATOR;
$PNG_WEB_DIR = 'temp/';

if (!file_exists($PNG_TEMP_DIR)) mkdir($PNG_TEMP_DIR);

// Consulta todos los registros de la solicitud previa
$consulta = mysqli_query($conn, "
    SELECT iddatadai, chasis, color, marca 
    FROM tb_datadai 
    WHERE id_solicitudprevia = $idsp AND condicion = 1
");

$qrItems = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    $iddai = $row['iddatadai'];
    $chasis = $row['chasis'];
    $color = $row['color'];
    $marca = $row['marca'];

    // Generar nombre único de archivo por chasis
    $filename = $PNG_TEMP_DIR . 'qr_' . md5($chasis) . '.png';
    QRcode::png($chasis, $filename, 'L', 6, 2);
    $qrPath = $PNG_WEB_DIR . basename($filename);

    $qrItems[] = [
        'chasis' => $chasis,
        'color' => $color,
        'marca' => $marca,
        'qrPath' => $qrPath
    ];

    // (opcional) Auditoría
    /*
    $actividad = "REGISTRO DE UNIDADES";
    mysqli_query($conn, "
        INSERT INTO tb_auditoria(fecha, hora, ip, detalle, id_datadai, id_usuario)
        VALUES ('$fecha_actual','$time_actual','$my_ip','$actividad','$iddai','$id_usuario')
    ");
    */
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>QRs LATKIC</title>
    <style>
        body { font-family: Arial; text-align: center; margin: 20px; }
        .qr-block { page-break-inside: avoid; margin-bottom: 40px; }
        img { width: 200px; height: 200px; }
        h3, h4 { margin: 5px 0; }
    </style>
</head>
<body>
    
    <?php foreach ($qrItems as $item): 
			echo "<center><h3> LATKIC S.A.</h3></center>";
	?>
        <div class="qr-block">
            <img src="<?= $item['qrPath'] ?>" alt="QR <?= htmlspecialchars($item['chasis']) ?>">
            <h4><?= htmlspecialchars($item['chasis']) ?></h4>
            <h4><?= htmlspecialchars($item['marca'] . ' ' . $item['color']) ?></h4>
        </div>
    <?php endforeach; ?>

    <script>
        window.print();
    </script>
</body>
</html>
