<?php
// views/pages/patio.php – Vista del patio (top-down con figura de carro)
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php");
  exit();
}
$usuario = $_SESSION['usuario'];
$permiso = $_SESSION['permiso'];
include("conex.php");
?>
<?php include 'partials/header.php'; ?>

<style>
  :root{
    --cell: 60px;                /* ancho del lote (columna) */
    --car-h: calc(var(--cell)*1.8); /* alto del carro / fila */
    --gap: 6px;
    --hd-h: 22px;
  }

  #patio-wrap{ overflow:auto; }

  /* Encabezados y grilla */
  #colheads, #grid{ display:grid; gap: var(--gap); }
  #colheads{ grid-auto-flow: column; }
  #rowheads{ display:grid; gap: var(--gap); }

  #colheads .hd, #rowheads .hd{
    width: var(--cell);
    height: var(--hd-h);
    display:flex; align-items:center; justify-content:center;
    font-size:12px; color:#334155;
    background:#f1f5f9;
    border:1px solid #e5e7eb;
    border-radius:6px; user-select:none;
  }

  #grid{ grid-auto-rows: var(--car-h); }

  /* Lote grande (si lo usas en otra parte) */
  .cell{
    width: var(--cell);
    height: var(--car-h);
    border:1px dashed #e5e7eb;
    border-radius:8px;
    position:relative;
    display:flex; align-items:center; justify-content:center;
    cursor:pointer; user-select:none;
    background: #f8fafc;
  }
  .cell.free  { background: #f0fdf4; }
  .cell.busy  { background: #fee2e2; }
  .cell.off   { background:#f8fafc; color:#94a3b8; border-style:dashed; }

  /* Carro grande */
  .car{
    pointer-events:none;
    width: calc(var(--cell) - 12px);
    height: calc(var(--car-h) - 12px);
    border-radius: 16px / 28px;
    position:absolute; inset: 6px; margin:auto;
    box-shadow: inset 0 1px 0 rgba(255,255,255,.35), 0 2px 6px rgba(0,0,0,.12);
  }
  .car::before, .car::after{
    content:''; position:absolute; left:14%; right:14%; height: 12%;
    background: rgba(255,255,255,.55); border-radius: 6px; box-shadow: inset 0 1px 2px rgba(0,0,0,.12);
  }
  .car::before{ top:7%; } .car::after { bottom:7%; }
  .car .roof{
    position:absolute; left:18%; right:18%; top:50%; height: 18%; transform: translateY(-50%);
    background: rgba(255,255,255,.28); border-radius: 8px; box-shadow: inset 0 1px 2px rgba(0,0,0,.08);
  }
  .wheel{
    position:absolute; width: 36%; height: 10%; background: #111827; border-radius: 12px;
    box-shadow: 0 1px 0 rgba(255,255,255,.15), inset 0 0 6px rgba(0,0,0,.5);
    filter: drop-shadow(0 1px 1px rgba(0,0,0,.25));
  }
  .wheel-tl{ top:10%;  left:-12%; transform: rotate(90deg); }
  .wheel-tr{ top:10%;  right:-12%; transform: rotate(90deg); }
  .wheel-bl{ bottom:10%; left:-12%; transform: rotate(90deg); }
  .wheel-br{ bottom:10%; right:-12%; transform: rotate(90deg); }

  /* Etiqueta centrada (genérica, no usada en subgrilla) */
  .tag{
    position:absolute; z-index:2; left:50%; top:50%;
    transform: translate(-50%, -50%);
    background: rgba(255,255,255,.85);
    color:#0f172a; padding:2px 6px; border-radius:6px;
    font-size:11px; font-weight:700; max-width: 90%;
    white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
    border:1px solid rgba(0,0,0,.05);
  }

  #hovercard{
    z-index:9999; min-width:240px; max-width:320px;
    padding:10px 12px; border-radius:12px;
    border:1px solid #e5e7eb; background:#fff;
    box-shadow:0 8px 20px rgba(0,0,0,.15);
    pointer-events:none;
  }
</style>

<style>
  /* Plano por áreas (por si lo usas más adelante) */
  .yard {
    display: grid;
    gap: var(--gap);
    grid-template-columns: 1fr 280px;
    grid-template-rows: 110px 110px minmax(360px, 1fr) 110px;
    grid-template-areas:
      "recep   pintura"
      "lavado  pintura"
      "almacen pintura"
      "acceso  acceso";
  }
  .zone { background:#fff; border:1px solid #e5e7eb; border-radius:12px; position:relative; overflow:hidden; }
  .zone__title {
    position: absolute; top: 8px; left: 12px;
    font-weight: 700; font-size: 13px; color: #0f172a;
    background: rgba(255,255,255,.9); border:1px solid #e5e7eb;
    border-radius: 8px; padding: 3px 8px; box-shadow: 0 2px 6px rgba(0,0,0,.05);
  }
  .zone__content { height: 100%; padding: 38px 12px 12px 12px; }
  .zone--almacen .zone__content-inner { display: flex; gap: 6px; height: 100%; }
</style>

<style>
  body{margin:0;font-family:system-ui,Arial}
  .wrap{max-width:980px;margin:2px auto;padding:2px}
  .plano{position:relative;display:inline-block;line-height:0}
  .plano img{max-width:100%;height:auto;display:block}

  /* Hotspots (áreas sobre la imagen) */
  .hotspot {
    position: absolute;
    cursor: pointer;
    border: 1px solid rgba(0,0,0,.15);
    border-radius: 8px;
    outline: 1px dashed transparent;
    transform-origin: center center;
  }
  .hotspot:hover{ outline:1px dashed rgba(0,0,0,.35) }

  /* Tooltip global */
  .tooltip{
    position:fixed; padding:6px 10px; border-radius:8px; background:#111; color:#fff;
    font-size:13px; pointer-events:none; opacity:0; transform:translate(-50%,-120%);
    transition:opacity .08s ease; box-shadow:0 6px 18px rgba(0,0,0,.18);
    border:1px solid rgba(255,255,255,.1);
    white-space:normal; max-width:280px; line-height:1.25;
  }
  .tooltip .dot{
    display:inline-block;width:10px;height:10px;border-radius:999px;margin-right:6px;
    vertical-align:middle;border:1px solid rgba(0,0,0,.25);background:#fff;
  }
  .tooltip .title{ font-weight:700; }

  /* Subgrilla */
  .hotspot .subgrid{
    position:absolute; inset:8px;
    display:grid; gap:6px;
  }
  .hotspot .subcell{
    position:relative; border:1px dashed rgba(0,0,0,.18); border-radius:6px;
    background: rgba(255,255,255,.25); overflow:hidden;
  }
  /* Estado visual del andén (subcelda) */
  .subcell.free { background:#dcfce7; border-color:#22c55e; }
  .subcell.busy { background:#fee2e2; border-color:#ef4444; }

  /* Mini-carro */
  .mini-car{
    pointer-events:none; position:absolute; inset:12%;
    border-radius: 10px / 18px;
    /* SIN color base: se pinta con .free/.busy */
    box-shadow: inset 0 1px 0 rgba(255,255,255,.35), 0 2px 6px rgba(0,0,0,.12);
    transform-origin: 50% 50%;
  }
  .mini-car.free {  background: linear-gradient(#22c55e,#16a34a); }
  .mini-car.busy {  background: linear-gradient(#ef4444,#dc2626); }
  .mini-car::before, .mini-car::after{
    content:''; position:absolute; left:14%; right:14%; height:12%;
    background: rgba(255,255,255,.55); border-radius:6px; box-shadow: inset 0 1px 2px rgba(0,0,0,.12);
  }
  .mini-car::before{ top:7%; } 
  .mini-car::after { bottom:7%; }
  .mini-car .roof{
    position:absolute; left:18%; right:18%; top:50%; height:18%; transform:translateY(-50%);
    background: rgba(255,255,255,.28); border-radius:8px; box-shadow: inset 0 1px 2px rgba(0,0,0,.08);
  }
  .mini-wheel{
    position:absolute; width:36%; height:10%; background:#111827; border-radius:12px;
    box-shadow:0 1px 0 rgba(255,255,255,.15), inset 0 0 6px rgba(0,0,0,.5);
    filter: drop-shadow(0 1px 1px rgba(0,0,0,.25));
  }
  .mini-wheel-tl{ top:10%;  left:-12%; transform: rotate(90deg); }
  .mini-wheel-tr{ top:10%;  right:-12%; transform: rotate(90deg); }
  .mini-wheel-bl{ bottom:10%; left:-12%; transform: rotate(90deg); }
  .mini-wheel-br{ bottom:10%; right:-12%; transform: rotate(90deg); }

  /* Horizontal (E, K) */
  .subgrid.horizontal .mini-car{
    left:50%; top:50%;
    width:88%; height:64%;
    transform: translate(-50%,-50%) rotate(90deg);
  }
  .subgrid.horizontal .subcell{ background: rgba(255,255,255,.18); }

  /* Badge de etiqueta para subgrillas */
  .slot-tag{
    position:absolute; left:50%; bottom:4px; transform:translateX(-50%);
    background:rgba(255,255,255,.85); color:#0f172a;
    padding:1px 4px; border-radius:4px; font-size:10px; font-weight:700;
    border:1px solid rgba(0,0,0,.05); z-index:2;
  }
</style>
<style>
  :root{
    --zoom-area: 1.45;   /* cuánto ampliar el área al hover */
    --zoom-car:  1.18;   /* cuánto ampliar los autos dentro del área */
  }

  /* El contenedor donde pones los hotspots sobre la imagen */
  #hotspots{ position:absolute; inset:0; overflow:visible; pointer-events:auto; }

  /* Cada área (A,B,C,...) debe ser un contenedor absoluto con class="area" */
  .area{
    position:absolute;
    transform-origin: var(--ox,50%) var(--oy,50%);
    transition: transform .18s ease, box-shadow .18s ease, z-index .18s ease;
    will-change: transform;
  }
  .area:hover,
  .area.zoom-active{ /* zoom también usable en touch con clase */
    transform: scale(var(--zoom-area));
    z-index: 100;
    box-shadow: 0 8px 24px rgba(0,0,0,.16);
  }

  /* Carros dentro del área */
  .area .car,
  .area .mini-car{
    transition: transform .12s ease, filter .12s ease;
    transform-origin: center center;
    will-change: transform;
  }
  .area:hover .car,
  .area:hover .mini-car{
    transform: scale(var(--zoom-car));
    filter: drop-shadow(0 2px 4px rgba(0,0,0,.15));
  }

  /* Para que el zoom no se recorte si el padre tenía overflow:hidden */
  #plano-wrap, #patio-wrap { overflow: visible !important; }
</style>
<body>
<div class="container-fluid">
  <div class="row">
    <?php include 'partials/menu.php'; ?>

    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <?php include 'partials/topbar.php'; ?>

      <section class="px-3 py-2">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h2 class="h6 m-0">Distribución de Patio</h2>
          <!-- Leyenda removida a pedido -->
        </div>

        <div class="wrap">          
          <div class="plano" id="plano">
            <img id="imgPlano" src="plano_gye_s.png" alt="Plano">
          </div>
        </div>
        <div class="tooltip" id="tip"><span class="dot" id="dot"></span><span id="tipText"></span></div>
      </section>

      <div id="hovercard" class="position-fixed d-none"></div>
    </main>
  </div>
</div>

<?php include 'partials/footer.php'; ?>

<script>
/* ======= CONFIG ======= */
const CONFIG = {
  areas: {
    A: { nombre: "Área A", color: "lightcoral",     coords: [970,550,1400,820]},
    B: { nombre: "Área B", color: "lightsalmon",    coords: [-35,770,680,850]},
    C: { nombre: "Área C", color: "palegreen",      coords: [-35,490,230,730]},
    D: { nombre: "Área D", color: "mediumpurple",   coords: [450,290,690,950],  rotation: 90},
    E: { nombre: "Área E", color: "khaki",          coords: [60,20,270,250]},
    //F: { nombre: "Área F", color: "khaki",          coords: [260,760,920,880] },
    //H: { nombre: "Área H", color: "lightseagreen",  coords: [950,760,1280,880] },
    //P: { nombre: "Área P", color: "paleturquoise",  coords: [250,345,1140,675]},   
    //T: { nombre: "Área B", color: "lightskyblue",   coords: [880,5,1150,185] },
    //L: { nombre: "Área L", color: "lightskyblue",   coords: [880,203,1150,300] },
    
    //E: { nombre: "Área E", color: "thistle",        coords: [560,200,660,280],  rotation: 90 },
    //G: { nombre: "Área G", color: "gold",           coords: [665,185,710,280] },
    //K: { nombre: "Área K", color: "peachpuff",      coords: [340,195,465,280],  rotation: 90 }
  }
};

const AREA_SPECS = {
  A: { cols: 14,  rows: 5,  horizontal: false },
  B: { cols: 17,  rows: 1,  horizontal: false },
  C: { cols: 9, rows: 4,  horizontal: false },
  D: { cols: 9, rows: 10,  horizontal: false },
  E: { cols: 12, rows: 2,  horizontal: false  },
  F: { cols: 3, rows: 3,  horizontal: false },

  H: { cols: 15, rows: 3,  horizontal: false },
  P: { cols: 35, rows: 9,  horizontal: false },  
  T: { cols: 10, rows: 5,  horizontal: false },
  L: { cols: 10, rows: 3,  horizontal: false },
  G: { cols: 1,  rows: 3,  horizontal: false },
  
  K: { cols: 5,  rows: 2,  horizontal: true  }
};

/* ===== Helpers ===== */
function cssColorToRGBA(color, alpha=0.22){
  const tmp = document.createElement('div');
  tmp.style.color = color;
  document.body.appendChild(tmp);
  const cs = getComputedStyle(tmp).color;
  document.body.removeChild(tmp);
  const m = cs.match(/rgba?\((\d+),\s*(\d+),\s*(\d+)/i);
  if(!m) return `rgba(37,99,235,${alpha})`;
  const [_, r, g, b] = m;
  return `rgba(${r},${g},${b},${alpha})`;
}
function normalizeCoords([x0,y0,x1,y1]){
  if (x1 < x0) [x0, x1] = [x1, x0];
  if (y1 < y0) [y0, y1] = [y1, y0];
  return [x0,y0,x1,y1];
}
function pxToPerc(x0,y0,x1,y1, naturalW, naturalH){
  const left = (x0/naturalW)*100;
  const top  = (y0/naturalH)*100;
  const w    = ((x1-x0)/naturalW)*100;
  const h    = ((y1-y0)/naturalH)*100;
  return {left,top,w,h};
}
// 0->A,1->B,... (para fallback)
function rowIndexToLetters(i){
  let n = i + 1, s = '';
  while (n > 0) {
    const r = (n - 1) % 26;
    s = String.fromCharCode(65 + r) + s;
    n = Math.floor((n - 1) / 26);
  }
  return s;
}
function getInfoByRC(letter, r, c){
  const area = ANDEN_MAP[letter] || {};
  return area[`${r}-${c}`] || null;
}

/* ===== DOM ===== */
const img = document.getElementById('imgPlano');
const cont = document.getElementById('plano');
const tip = document.getElementById('tip');
const tipText = document.getElementById('tipText');
const dot = document.getElementById('dot');

/* ===== Estado desde BD ===== */
let ANDEN_MAP = {}; // { 'A': { 'fila-col': { ... }, ... }, ... }

/* ===== Subgrilla ===== */
function buildSubgridForArea(letter, hs) {
  const spec = AREA_SPECS[letter];
  if (!spec) return;

  const sub = document.createElement('div');
  sub.className = 'subgrid' + (spec.horizontal ? ' horizontal' : '');
  Object.assign(sub.style, {
    display: 'grid',
    gridTemplateColumns: `repeat(${spec.cols}, 1fr)`,
    gridTemplateRows: `repeat(${spec.rows}, 1fr)`,
    gap: '6px',
    position: 'absolute',
    inset: '8px'
  });

  const def = CONFIG.areas[letter];

  for (let r = 0; r < spec.rows; r++) {
    for (let c = 0; c < spec.cols; c++) {
      const cell = document.createElement('div');
      cell.className = 'subcell';
      // pinta borde con color del área
      cell.style.borderColor = cssColorToRGBA(def.color, 0.55);

      // Carrito
      const car = document.createElement('div');
      car.className = 'mini-car';
      const roof = document.createElement('div');
      roof.className = 'roof';
      car.appendChild(roof);
      ['tl','tr','bl','br'].forEach(pos => {
        const w = document.createElement('i');
        w.className = 'mini-wheel mini-wheel-' + pos;
        car.appendChild(w);
      });
      cell.appendChild(car);

      // Datos desde BD por (fila, columna)
      const info = getInfoByRC(letter, r + 1, c + 1);

      // Detectar ocupado con distintos posibles campos
      const ocupado = !!(
        info && (
          info.ocupado === 1 || info.ocupado === true ||
          info.activo  === 1 || info.activo  === true ||
          String(info.estado || '').toUpperCase() === 'OCUPADO'
        )
      );

      // Estado visual: subcelda + mini-car
      cell.classList.add(ocupado ? 'busy' : 'free');
      car.classList.add(ocupado ? 'busy' : 'free');

      // Etiqueta prioriza DB; fallback AREA-<fila letras><col>
      const etiquetaDB = (info && typeof info.etiqueta === 'string') ? info.etiqueta.trim() : '';
      const etiqueta = etiquetaDB !== '' ? etiquetaDB : `${letter}-${rowIndexToLetters(r)}${c+1}`;

      // Badge
      const tag = document.createElement('div');
      tag.className = 'slot-tag';
      tag.textContent = etiqueta;
      cell.appendChild(tag);

      // Dataset
      cell.dataset.area    = letter;
      cell.dataset.fila    = String(r + 1);
      cell.dataset.columna = String(c + 1);
      cell.dataset.idAnden = info?.id_anden ? String(info.id_anden) : '';

      // Helpers tooltip
      const fmt = (v) => {
        const s = (v ?? '').toString().trim();
        return s === '' ? '—' : s;
      };
      function showTip(e){
        const x = (e.clientX ?? e.touches?.[0]?.clientX);
        const y = (e.clientY ?? e.touches?.[0]?.clientY);

        const html = (ocupado && info)
          ? `<span class="title">${etiqueta}</span><br>
             <small>Chasis: ${fmt(info.chasis)}<br>
             Marca: ${fmt(info.marca)}<br>
             Modelo: ${fmt(info.modelo)}<br>
             Color: ${fmt(info.color)}</small>`
          : `<span class="title">${etiqueta}</span><br><small>Libre</small>`;

        tipText.innerHTML = html;
        dot.style.background = def.color;
        tip.style.left = x + 'px';
        tip.style.top  = y + 'px';
        tip.style.opacity = '1';
      }

      // Tooltip eventos
      cell.addEventListener('mousemove', (e)=>{ e.stopPropagation(); showTip(e); });
      cell.addEventListener('mouseleave', ()=>{ tip.style.opacity = '0'; });
      cell.addEventListener('touchstart', (e)=>{ showTip(e); setTimeout(()=> tip.style.opacity = '0', 1200); }, { passive:true });

      // Click payload (por si abres modal)
      cell.addEventListener('click', (ev) => {
        ev.stopPropagation();
        const payload = {
          area: letter,
          fila: r + 1,
          columna: c + 1,
          id_anden: info?.id_anden ?? null,
          ocupado,
          etiqueta,
          vehiculo: info ? {
            chasis: info.chasis || null,
            marca:  info.marca  || null,
            modelo: info.modelo || null,
            color:  info.color  || null
          } : null
        };
        console.log('CLICK ANDEN', payload);
        // openAsignarModal(payload);
      });

      sub.appendChild(cell);
    }
  }

  hs.appendChild(sub);
}

/* ===== Hotspots + subgrillas ===== */
function createHotspots(){
  cont.querySelectorAll('.hotspot').forEach(el=>el.remove());

  const naturalW = img.naturalWidth;
  const naturalH = img.naturalHeight;

  Object.entries(CONFIG.areas).forEach(([letter, def])=>{
    const [X0,Y0,X1,Y1] = normalizeCoords(def.coords);
    const {left,top,w,h} = pxToPerc(X0,Y0,X1,Y1,naturalW,naturalH);

    const hs = document.createElement('div');
    hs.className='hotspot';
    hs.style.left   = left+'%';
    hs.style.top    = top+'%';
    hs.style.width  = w+'%';
    hs.style.height = h+'%';
    hs.style.background  = cssColorToRGBA(def.color, 0.22);
    hs.style.borderColor = cssColorToRGBA(def.color, 0.45);
    const rot = Number(def.rotation ?? 0);
    hs.style.transform = `rotate(${rot}deg)`;

    hs.dataset.letter = letter;
    hs.dataset.nombre = def.nombre;
    hs.dataset.color  = def.color;

    // Tooltip de área
    hs.addEventListener('mousemove', (e)=>{
      tipText.innerHTML = `<span class="title">${hs.dataset.letter} – ${hs.dataset.nombre}</span>`;
      dot.style.background = hs.dataset.color;
      tip.style.left = e.clientX+'px';
      tip.style.top  = e.clientY+'px';
      tip.style.opacity = '1';
    });
    hs.addEventListener('mouseleave', ()=>{ tip.style.opacity='0'; });
    hs.addEventListener('touchstart', (e)=>{
      const t = e.touches[0];
      tipText.innerHTML = `<span class="title">${hs.dataset.letter} – ${hs.dataset.nombre}</span>`;
      dot.style.background = hs.dataset.color;
      tip.style.left = t.clientX+'px';
      tip.style.top  = t.clientY+'px';
      tip.style.opacity='1';
      setTimeout(()=>tip.style.opacity='0', 1200);
    }, {passive:true});

    cont.appendChild(hs);

    // Subgrilla
    buildSubgridForArea(letter, hs);
  });
}

/* ===== Fetch estado + render (mapeo por fila/columna) ===== */
async function fetchAndenes(query = '?bodega=Quito'){
  try {
    const res = await fetch(`api/patio_map_g.php${query}`, { cache: 'no-store' });
    const json = await res.json();
    if (!json.success) throw new Error(json.message || 'Error API');

    // Pre-indexar: ANDEN_MAP[area][ "fila-columna" ] = item
    const tmp = {};
    for (const [area, arr] of Object.entries(json.areas || {})) {
      tmp[area] = {};
      for (const it of arr) {
        const f = Number(it.fila) || 0;
        const c = Number(it.columna) || 0;
        tmp[area][`${f}-${c}`] = it;
      }
    }
    ANDEN_MAP = tmp;
  } catch (err) {
    console.error('Error cargando mapa de andenes:', err);
    ANDEN_MAP = {};
  }

  if (img.complete && img.naturalWidth) {
    createHotspots();
  } else {
    img.addEventListener('load', createHotspots, {once:true});
  }
}

/* ===== Init ===== */
fetchAndenes('?bodega=Quito');

/* ===== Tooltip boundary ===== */
document.addEventListener('mousemove', (e)=>{
  const pad=8, vw=window.innerWidth, vh=window.innerHeight;
  let x=e.clientX, y=e.clientY;
  x=Math.max(pad, Math.min(vw-pad, x));
  y=Math.max(pad, Math.min(vh-pad, y));
  if(tip.style.opacity==='1'){ tip.style.left=x+'px'; tip.style.top=y+'px'; }
});

/* ===== Redraw on resize ===== */
let resizeTO;
window.addEventListener('resize', () => {
  clearTimeout(resizeTO);
  resizeTO = setTimeout(() => createHotspots(), 120);
});
</script>
<script>
/** Actualiza transform-origin al punto del cursor para “centrar” el zoom */
function enableHoverZoomOrigin(){
  const root = document.getElementById('hotspots') || document;
  root.addEventListener('mousemove', (e)=>{
    const area = e.target.closest('.area');
    if(!area) return;
    const r = area.getBoundingClientRect();
    const ox = ((e.clientX - r.left) / r.width)  * 100;
    const oy = ((e.clientY - r.top)  / r.height) * 100;
    area.style.setProperty('--ox', ox + '%');
    area.style.setProperty('--oy', oy + '%');
  }, {passive:true});
}

/** (Opcional) Soporte táctil: tap para activar/desactivar zoom en móviles */
function enableTouchZoom(){
  const root = document.getElementById('hotspots') || document;
  root.addEventListener('touchstart', (e)=>{
    const area = e.target.closest('.area');
    if(!area) return;
    area.classList.toggle('zoom-active');
    // centra origen al toque
    const t = e.touches[0];
    const r = area.getBoundingClientRect();
    const ox = ((t.clientX - r.left)/r.width)*100;
    const oy = ((t.clientY - r.top)/r.height)*100;
    area.style.setProperty('--ox', ox + '%');
    area.style.setProperty('--oy', oy + '%');
  }, {passive:true});
}

/* Llama esto después de crear los hotspots */
function initZoomInteractions(){
  enableHoverZoomOrigin();
  enableTouchZoom();
}

/* Ejemplo: tras tu createHotspots() */
const _origCreateHotspots = (typeof createHotspots === 'function') ? createHotspots : null;
window.createHotspots = function(){
  if (_origCreateHotspots) _origCreateHotspots();
  // asegúrate de que tus áreas tengan class="area" y los carros ".car" o ".mini-car"
  initZoomInteractions();
};
</script>
</body>
</html>
