<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Plano: tooltip con nombre y color por área</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
  body{margin:0;font-family:system-ui,Arial}
  .wrap{max-width:1200px;margin:12px auto;padding:8px}
  h3{margin:8px 0 10px;font-size:18px}
  .plano{position:relative;display:inline-block;line-height:0}
  .plano img{max-width:100%;height:auto;display:block}
  .hotspot{position:absolute;outline:1px dashed transparent;cursor:pointer}
  .hotspot:hover{outline:1px dashed rgba(0,0,0,.25)}

  /* Tooltip */
  .tooltip{
    position:fixed;
    padding:6px 10px;border-radius:8px;background:#111;color:#fff;
    font-size:13px;pointer-events:none;opacity:0;transform:translate(-50%,-120%);
    white-space:nowrap;transition:opacity .08s ease;
    box-shadow:0 6px 18px rgba(0,0,0,.18);
    border:1px solid rgba(255,255,255,.1);
  }
  .tooltip .dot{
    display:inline-block;width:10px;height:10px;border-radius:999px;margin-right:6px;
    vertical-align:middle;border:1px solid rgba(0,0,0,.25);background:#fff;
  }
  .legend{display:grid;grid-template-columns:repeat(auto-fit,minmax(120px,1fr));gap:8px;margin-top:10px}
  .legend .item{display:flex;align-items:center;gap:6px;border:1px solid #e5e7eb;border-radius:8px;padding:6px 8px}
  .legend .swatch{width:14px;height:14px;border-radius:3px;border:1px solid rgba(0,0,0,.2)}
  .legend .label{font-size:13px;color:#222}
</style>
</head>
<body>
<div class="wrap">
  <h3>Plano (pase el cursor para ver letra y nombre del área)</h3>
  <div class="plano" id="plano">
    <!-- Cambia el src si tu archivo tiene otro nombre -->
    <img id="imgPlano" src="plano_diceño.jpg" alt="Plano">
  </div>

  <!-- Leyenda generada con los mismos nombres/colores -->
  <div class="legend" id="legend"></div>
</div>

<div class="tooltip" id="tip"><span class="dot" id="dot"></span><span id="tipText"></span></div>

<script>
/* ======= CONFIGURACIÓN ÚNICA =======
   - Edita aquí nombres y colores (HTML o hex).
   - Las coordenadas están en pixeles relativas a la imagen original.
*/
const CONFIG = {
  areas: {
    A: { nombre: "Área A", color: "lightcoral",      coords: [ 40,620,110,720] },
    T: { nombre: "Área T", color: "lightsalmon",     coords: [115,620,160,720] },
    F: { nombre: "Área F", color: "khaki",           coords: [165,620,360,720] },
    H: { nombre: "Área H", color: "lightseagreen",   coords: [370,620,600,720] },
    I: { nombre: "Área I", color: "plum",            coords: [620,640,720,720] },
    G: { nombre: "Área G", color: "gold",            coords: [620,580,700,630] },
    P: { nombre: "Área P", color: "paleturquoise",   coords: [ 40,280,500,500] },
    C: { nombre: "Área C", color: "palegreen",       coords: [510,300,720,430] },
    O: { nombre: "Área O", color: "lightpink",       coords: [500,510,530,540] },
    J: { nombre: "Área J", color: "wheat",           coords: [540,450,640,500] },
    B: { nombre: "Área B", color: "lightskyblue",    coords: [200, 50,480,230] },
    D: { nombre: "Área D", color: "mediumpurple",    coords: [490, 50,720,230] },
    E: { nombre: "Área E", color: "thistle",         coords: [150,100,190,150] },
    K: { nombre: "Área K", color: "peachpuff",       coords: [ 90, 90,140,150] }
  }
};
/* =================================== */

const img = document.getElementById('imgPlano');
const cont = document.getElementById('plano');
const tip = document.getElementById('tip');
const tipText = document.getElementById('tipText');
const dot = document.getElementById('dot');
const legendEl = document.getElementById('legend');

function pxToPerc(x0,y0,x1,y1, naturalW, naturalH){
  const left = (x0/naturalW)*100;
  const top  = (y0/naturalH)*100;
  const w    = ((x1-x0)/naturalW)*100;
  const h    = ((y1-y0)/naturalH)*100;
  return {left,top,w,h};
}

function createHotspots(){
  // Limpia previos
  cont.querySelectorAll('.hotspot').forEach(el=>el.remove());
  legendEl.innerHTML = '';

  const naturalW = img.naturalWidth;
  const naturalH = img.naturalHeight;

  Object.entries(CONFIG.areas).forEach(([letter, def])=>{
    const [x0,y0,x1,y1] = def.coords;
    const {left,top,w,h} = pxToPerc(x0,y0,x1,y1,naturalW,naturalH);

    // Hotspot
    const hs = document.createElement('div');
    hs.className='hotspot';
    hs.style.left  = left+'%';
    hs.style.top   = top+'%';
    hs.style.width = w+'%';
    hs.style.height= h+'%';
    hs.dataset.letter = letter;
    hs.dataset.nombre = def.nombre;
    hs.dataset.color  = def.color;

    // Hover (mouse)
    hs.addEventListener('mousemove', (e)=>{
      tipText.textContent = `${hs.dataset.letter} – ${hs.dataset.nombre}`;
      dot.style.background = hs.dataset.color;
      tip.style.left = e.clientX+'px';
      tip.style.top  = e.clientY+'px';
      tip.style.opacity = '1';
    });
    hs.addEventListener('mouseleave', ()=>{
      tip.style.opacity='0';
    });

    // Tap (touch)
    hs.addEventListener('touchstart', (e)=>{
      const t = e.touches[0];
      tipText.textContent = `${hs.dataset.letter} – ${hs.dataset.nombre}`;
      dot.style.background = hs.dataset.color;
      tip.style.left = t.clientX+'px';
      tip.style.top  = t.clientY+'px';
      tip.style.opacity='1';
      setTimeout(()=>tip.style.opacity='0', 1200);
    }, {passive:true});

    cont.appendChild(hs);

    // Leyenda
    const item = document.createElement('div');
    item.className = 'item';
    item.innerHTML = `
      <span class="swatch" style="background:${def.color}"></span>
      <span class="label"><strong>${letter}</strong> – ${def.nombre}</span>
    `;
    legendEl.appendChild(item);
  });
}

if (img.complete && img.naturalWidth) {
  createHotspots();
} else {
  img.addEventListener('load', createHotspots);
}

// Ajuste de tooltip para no salirse de la pantalla (margen pequeño)
document.addEventListener('mousemove', (e)=>{
  const pad=8, vw=window.innerWidth, vh=window.innerHeight;
  let x=e.clientX, y=e.clientY;
  x=Math.max(pad, Math.min(vw-pad, x));
  y=Math.max(pad, Math.min(vh-pad, y));
  if(tip.style.opacity==='1'){ tip.style.left=x+'px'; tip.style.top=y+'px'; }
});
</script>
</body>
</html>
