<?php
// index.php modernizado para SGO
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
	header("Location: ../../views/index.php");
	exit();
}

$usuario = $_SESSION['usuario'];
$permiso = $_SESSION['permiso'];
include("conex.php");
?>

<?php include 'partials/header.php'; ?>

<body>
<div class="container-fluid">
  <div class="row">
  
    <!-- Sidebar -->
    <?php include 'partials/menu.php'; ?>

    <!-- Contenido principal -->
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      
      <!-- Barra superior (topbar) con fondo rojo y reloj en vivo -->
      <?php include 'partials/topbar.php'; ?>

      <!-- Paneles de conteo o tarjetas principales -->
      <div class="row g-3 mt-2" id="paneles">
        <?php include 'partials/cards.php'; ?>
      </div>

    </main>
  </div>
</div>


<?php include 'partials/footer.php'; ?>

<script>
  function cargarConteo() {
    fetch('api/contar_dai.php')
      .then(response => response.json())
      .then(data => {
        document.getElementById('dai70_total').textContent = data.dai70;
        document.getElementById('dai10_total').textContent = data.dai10;
        document.getElementById('simple_total').textContent = data.simple;
      });
  }

  setInterval(cargarConteo, 60000); // Actualiza cada 60s
  cargarConteo(); // Primera carga inmediata
</script>


</body>
</html>
