<?php  
// index.php — FACTURAS INFORMATIVAS: multi-chasis, crear SIN Pedido/Fecha/Moneda, guardado en lote — Opción A
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = $_SESSION['permiso'] ?? '';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Facturas Informativas</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet" />

  <!-- DataTables Bundle: DT + Buttons (ColVis/HTML5/Print) + Responsive + JSZip -->
  <link rel="stylesheet"
        href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.css"/>

  <style>
    :root { --fz: 0.98rem; }
    body { font-size: var(--fz); }
    .table td, .table th { vertical-align: middle; }
    .form-label { margin-bottom: .25rem; }
    .btn-sm { padding: .25rem .5rem; }
    .modal-header { background:#f6f7fb; }
    #bloqueVehiculos { transition: opacity .2s ease-in-out; }
    #dai{font-size:12px}
    #dai thead th{font-size:12px}
    #dai tbody td{font-size:11px}
    .tabla-preview{font-size:9px;width:90%;table-layout:auto}
    .tabla-preview th,.tabla-preview td{white-space:nowrap;padding:4px 8px;vertical-align:middle}
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <!-- Sidebar -->
    <?php include __DIR__ . '/partials/menu.php'; ?>

    <!-- Contenido principal -->
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <!-- Topbar -->
      <?php include __DIR__ . '/partials/topbar.php'; ?>
      <div class="container-fluid py-2">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h5 class="m-0"><i class="fa-solid fa-file-invoice-dollar me-2"></i>Facturas informativas</h5>
          <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#factura_modal">
            <i class="fa-solid fa-file-circle-plus me-1"></i> Nueva factura
          </button>
        </div>

        <div class="card shadow-sm">
          <div class="card-body p-2">
            <div class="table-responsive">
              <table id="factura" class="table table-striped table-hover table-sm w-100">
                <thead class="table-info">
                  <tr>
                    <th>Nro.</th>
                    <th>Fecha</th>
                    <th>Cliente</th>
                    <th>Pedido</th>
                    <th>Embarque</th>
                    <th>SP</th>
                    <th>DAI</th>
                    <th>Acciones</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<!-- ========= MODAL: NUEVA FACTURA ========= -->
<div class="modal fade" id="factura_modal" tabindex="-1" aria-labelledby="facturaLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title" id="facturaLabel"><i class="fa-solid fa-file-circle-plus me-2"></i>Nueva factura informativa</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <div class="modal-body">
        <!-- Cabecera (AL CREAR: sin Pedido/Fecha/Moneda) -->
        <form id="formFactura" autocomplete="off">
          <div class="row g-2">
            <div class="col-12 col-md-3">
              <label class="form-label mb-0">RUC / Cédula</label>
              <div class="input-group input-group-sm">
                <input type="text" class="form-control" id="ruc" name="ruc" placeholder="Ingrese RUC/Cédula">
                <button class="btn btn-outline-primary btn-sm" type="button" id="btnBuscarRuc" title="Buscar">
                  <i class="fa-solid fa-magnifying-glass"></i>
                </button>
              </div>
              <small id="empresaEstado" class="text-muted"></small>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label mb-0">Razón Social / Nombre</label>
              <input type="text" class="form-control form-control-sm" id="nombre" name="nombre" placeholder="Se llena si no existe empresa">
            </div>

            <!-- Ocultos -->
            <input type="hidden" id="id_cliente" name="id_cliente" value="">
            <input type="hidden" id="exonerado" name="exonerado" value="0">
          </div>
        </form>

        <hr class="my-2">

        <!-- Vehículos -->
        <form id="formVehiculo" onsubmit="return false;">
          <div id="bloqueVehiculos" style="pointer-events:none; opacity:.6;">
            <div class="row g-2 align-items-end">
              <div class="col-lg-6 col-md-6">
                <label class="form-label">INGRESE CHASIS *</label>
                <input class="form-control form-control-sm" id="chasis" name="chasis"
                       placeholder="Pega varios: separados por líneas, espacios o comas" />
                <small class="text-muted">Pega varios chasis y se buscarán automáticamente.</small>
              </div>
              <div class="col-lg-6 col-md-6">
                <div class="d-flex gap-2">
                  <button type="button" class="btn btn-primary btn-sm" id="btnAgregar">
                    <i class="fa fa-plus"></i> Agregar/Buscar
                  </button>
                  <button type="button" class="btn btn-outline-secondary btn-sm" id="btnPegarLista">
                    <i class="fa fa-paste"></i> Pegar lista
                  </button>
                  <button type="button" class="btn btn-outline-danger btn-sm" id="btnLimpiarTabla">
                    <i class="fa fa-trash"></i> Limpiar tabla
                  </button>
                </div>
              </div>

              <div class="col-12">
                <div class="table-responsive">
                  <table class="table table-sm table-striped align-middle">
                    <thead class="table-light">
                      <tr>
                        <th>#</th>
                        <th>Item</th>
                        <th>Marca</th>
                        <th>Chasis</th>
                        <th>Motor</th>
                        <th>FOB Unit.</th>
                        <th>Transporte</th>
                        <th>Seguro</th>
                        <th>Valor Aduana</th>
                        <th></th>
                      </tr>
                    </thead>
                    <tbody id="tbodyVehiculos"></tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>

      <div class="modal-footer py-2">
        <small id="estadoGuardado" class="me-auto text-muted"></small>
        <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-success btn-sm" id="btnGuardarTodo">
          <i class="fa-solid fa-floppy-disk me-1"></i>Guardar
        </button>
      </div>
    </div>
  </div>
</div>

<!-- ===== JS ===== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.js"></script>

<script>
/* =================== Estado global =================== */
let tablaFacturas = null;
let vehiculosBuffer = []; // {iddatadai,item,marca,chasis,motor,descripcion,modelo,fobunitario,transporte,seguro,valoraduana}

/* =================== Helpers =================== */
function escapeHtml(s){return String(s).replaceAll('&','&amp;').replaceAll('<','&lt;').replaceAll('>','&gt;').replaceAll('"','&quot;').replaceAll("'",'&#039;');}
function normalizarChasis(s){ return String(s||'').toUpperCase().replace(/[^A-Z0-9]/g,'').trim(); }
function tokensChasis(raw){
  return String(raw||'').split(/[\s,;|\n\r]+/).filter(Boolean)
    .map(normalizarChasis).filter(c => c.length >= 8 && c.length <= 25);
}
// Conversor robusto a número (maneja 1.234,56 y 1,234.56)
function toNumber(x){
  let s = String(x ?? '').trim();
  if (!s) return 0;
  s = s.replace(/\s/g,'');
  const hasComma = s.includes(',');
  const hasDot = s.includes('.');
  if (hasComma && hasDot){ s = s.replace(/\./g,'').replace(',', '.'); }
  else if (hasComma){ s = s.replace(',', '.'); }
  const n = parseFloat(s);
  return isNaN(n) ? 0 : n;
}
function toggleVehiculosBlock(){
  const idCliente= (document.getElementById('id_cliente')?.value||'').trim();
  const exonerado= (document.getElementById('exonerado')?.value||'0').trim();
  const nombre   = (document.getElementById('nombre')?.value||'').trim();
  const bloque   = document.getElementById('bloqueVehiculos');
  if (!bloque) return;
  const okCliente = (idCliente !== '') || (exonerado === '1' && nombre !== '');
  if (okCliente){ bloque.style.pointerEvents='auto'; bloque.style.opacity='1'; }
  else { bloque.style.pointerEvents='none'; bloque.style.opacity='.6'; }
}
function resetModal(){
  document.getElementById('formFactura')?.reset();
  document.getElementById('formVehiculo')?.reset();
  const est = document.getElementById('empresaEstado'); if (est) est.textContent = '';
  const exo = document.getElementById('exonerado'); if (exo) exo.value = '0';
  const idc = document.getElementById('id_cliente'); if (idc) idc.value = '';
  const nom = document.getElementById('nombre'); if (nom) nom.readOnly = false;
  vehiculosBuffer = [];
  renderVehiculosBuffer();
  toggleVehiculosBlock();
}

/* =================== Empresa =================== */
async function buscarEmpresa(){
  const rucEl = document.getElementById('ruc');
  const ruc = (rucEl?.value||'').trim();
  const est = document.getElementById('empresaEstado');
  if (!ruc){ if(est) est.innerHTML = '<span class="text-danger">Ingrese RUC/Cédula.</span>'; return; }
  try{
    const res = await fetch('api/empresa_buscar.php?ruc='+encodeURIComponent(ruc));
    const j = await res.json();
    const idc = document.getElementById('id_cliente');
    const exo = document.getElementById('exonerado');
    const nom = document.getElementById('nombre');
    if (j.success && j.idempresa){
      if (idc) idc.value = String(j.idempresa);
      if (exo) exo.value = '0';
      if (nom){ nom.value = j.razon_social || ''; nom.readOnly = true; }
      if (est) est.innerHTML = '<span class="text-success">Empresa encontrada.</span>';
    } else {
      if (idc) idc.value = '';
      if (exo) exo.value = '1';
      if (nom) nom.readOnly = false;
      if (est) est.innerHTML = '<span class="text-warning">No encontrada: ingrese nombre (exonerado).</span>';
    }
    toggleVehiculosBlock();
  }catch(e){
    console.error(e);
    if (est) est.innerHTML = '<span class="text-danger">Error al buscar.</span>';
  }
}

/* =================== Render tabla de vehículos =================== */
function renderVehiculosBuffer(){
  const tbody = document.getElementById('tbodyVehiculos');
  if (!tbody) return;
  tbody.innerHTML = '';
  vehiculosBuffer.forEach((v, i)=>{
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td>${i+1}</td>
      <td>${escapeHtml(v.item||'')}</td>
      <td>${escapeHtml(v.marca||'')}</td>
      <td>${escapeHtml(v.chasis||'')}</td>
      <td>${escapeHtml(v.motor||'')}</td>
      <td>${escapeHtml(v.fobunitario ?? '')}</td>
      <td>${escapeHtml(v.transporte ?? '')}</td>
      <td>${escapeHtml(v.seguro ?? '')}</td>
      <td>${escapeHtml(v.valoraduana ?? '')}</td>
      <td class="text-end">
        <button type="button" class="btn btn-outline-danger btn-sm" title="Quitar"
          onclick="vehiculosBuffer.splice(${i},1); renderVehiculosBuffer();">
          <i class="fa fa-trash"></i>
        </button>
      </td>`;
    tbody.appendChild(tr);
  });
}

/* =================== DAI =================== */
async function buscarChasisDatadai(chasis){
  try{
    const res = await fetch('api/datadai_buscar.php?chasis='+encodeURIComponent(chasis));
    const j = await res.json();
    return (j.success && j.data) ? j.data : null;
  }catch(e){ console.error(e); return null; }
}
async function buscarChasisDatadaiLote(lista){
  try{
    const res = await fetch('api/datadai_buscar_lote.php', {
      method: 'POST',
      headers: {'Content-Type':'application/json; charset=utf-8'},
      body: JSON.stringify({ chasis: lista })
    });
    return await res.json(); // {success, found, not_found}
  }catch(e){ console.error(e); return { success:false, message:'Error de red' }; }
}
function pushResultadosAlBuffer(resultados){
  let ok=0;
  const ya = new Set(vehiculosBuffer.map(v => normalizarChasis(v.chasis||'')));
  for (const d of (resultados||[])){
    const ch = normalizarChasis(d.chasis||''); if (!ch || ya.has(ch)) continue;
    const fob = (d.fobunitario!=null && d.fobunitario!=='') ? d.fobunitario : (d.fobitem||null);
    vehiculosBuffer.push({
      iddatadai: d.iddatadai ?? null, item: d.item ?? '', marca: d.marca ?? '',
      chasis: d.chasis ?? ch, motor: d.motor ?? '', descripcion: d.descripcion ?? '',
      modelo: d.modelo ?? '', fobunitario: fob, transporte: d.transporte ?? null,
      seguro: d.seguro ?? null, valoraduana: d.valoraduana ?? null
    });
    ok++;
  }
  return ok;
}

/* =================== Agregar/Buscar =================== */
async function procesarInputChasis(raw){
  const lista = [...new Set(tokensChasis(raw))];
  if (!lista.length){ alert('No hay chasis válidos.'); return; }

  // Validar cabecera (SOLO Cliente/Nombre exonerado)
  const idCliente= (document.getElementById('id_cliente')?.value||'').trim();
  const exonerado= (document.getElementById('exonerado')?.value||'0').trim();
  const nombre   = (document.getElementById('nombre')?.value||'').trim();
  const okCliente = (idCliente !== '') || (exonerado === '1' && nombre !== '');
  if (!okCliente){
    alert('Primero: RUC/Cédula (o nombre si no existe).');
    return;
  }

  const tbody = document.getElementById('tbodyVehiculos');
  if (!tbody) return;
  const ph = document.createElement('tr');
  ph.innerHTML = `<td colspan="10" class="text-center">Buscando ${lista.length} chasis...</td>`;
  tbody.appendChild(ph);

  let agregados = 0, notFound = [];
  if (lista.length === 1){
    const unico = lista[0];
    const ya = new Set(vehiculosBuffer.map(v => normalizarChasis(v.chasis||'')));
    if (ya.has(unico)){ ph.remove(); alert('Este chasis ya está en la tabla.'); return; }
    const d = await buscarChasisDatadai(unico);
    ph.remove();
    if (d){ agregados = pushResultadosAlBuffer([d]); }
    else { notFound = [unico]; }
  } else {
    const resp = await buscarChasisDatadaiLote(lista);
    ph.remove();
    if (!resp.success){ alert(resp.message || 'No se pudo consultar.'); return; }
    agregados = pushResultadosAlBuffer(resp.found||[]);
    notFound = resp.not_found||[];
  }

  renderVehiculosBuffer();
  if (notFound.length){
    const tr = document.createElement('tr');
    tr.className = 'table-warning';
    tr.innerHTML = `<td></td><td colspan="3">${escapeHtml(notFound.join(', '))}</td>
                    <td colspan="6"><span class="badge text-bg-warning">No encontrado(s)</span></td>`;
    tbody.appendChild(tr);
  }
}

async function agregarVehiculoBuffer(){
  const inp = document.getElementById('chasis');
  const raw = (inp?.value||'').trim();
  if (!raw){ alert('Ingrese o pegue uno o varios chasis.'); return; }
  await procesarInputChasis(raw);
  if (inp) inp.value = '';
}

/* =================== Guardar todo =================== */
async function guardarTodo(){
  const btn = document.getElementById('btnGuardarTodo');
  const estado = document.getElementById('estadoGuardado');
  try{
    if (btn) btn.disabled = true; if (estado) estado.textContent = 'Guardando...';

    const idCliente= (document.getElementById('id_cliente')?.value||'').trim();
    const exonerado= (document.getElementById('exonerado')?.value||'0').trim();
    const nombre   = (document.getElementById('nombre')?.value||'').trim();
    const okCliente = (idCliente !== '') || (exonerado === '1' && nombre !== '');
    if (!okCliente){
      alert('RUC/Cédula (o nombre) son obligatorios.');
      if (btn) btn.disabled=false; if (estado) estado.textContent=''; return;
    }

    // Debe haber al menos un vehículo con iddatadai
    const ids = vehiculosBuffer
      .map(v => parseInt(v.iddatadai, 10))
      .filter(n => Number.isInteger(n) && n > 0);

    if (!ids.length){
      alert('Agrega al menos un chasis válido (con iddatadai) antes de guardar.');
      if (btn) btn.disabled=false; if (estado) estado.textContent=''; return;
    }

    // ===== Calcular totales desde la tabla =====
    const cantidad = vehiculosBuffer.length;
    const totalfob = vehiculosBuffer.reduce((a,v)=> a + toNumber(v.fobunitario), 0);
    const totalflete = vehiculosBuffer.reduce((a,v)=> a + toNumber(v.transporte), 0);
    const totalseguro = vehiculosBuffer.reduce((a,v)=> a + toNumber(v.seguro), 0);
    const totalAduana = vehiculosBuffer.reduce((a,v)=> a + toNumber(v.valoraduana), 0);
    const total = totalAduana > 0 ? totalAduana : (totalfob + totalflete + totalseguro);

    // 1) Crear factura + enviar lista de iddatadai + sumas
    const fdFactura = new FormData(document.getElementById('formFactura'));
    fdFactura.set('iddatadai_list', JSON.stringify(ids));
    fdFactura.set('cantidad', String(cantidad));
    fdFactura.set('totalfob', String(totalfob));
    fdFactura.set('totalflete', String(totalflete));
    fdFactura.set('totalseguro', String(totalseguro));
    fdFactura.set('total', String(total));

    const rFac = await fetch('api/facturas_crear.php', { method:'POST', body: fdFactura });

    // Respuesta robusta: texto -> JSON
    const resText = await rFac.text();
    let jFac = null;
    try { jFac = JSON.parse(resText); }
    catch (e) {
      console.error('Respuesta no JSON de facturas_crear.php:', resText);
      alert('Error del servidor (no JSON): ' + resText.slice(0, 500));
      if (btn) btn.disabled=false; if (estado) estado.textContent=''; 
      return;
    }

    if (!jFac.success){
      alert(jFac.message || 'No se pudo crear la factura.');
      if (btn) btn.disabled=false; if (estado) estado.textContent=''; 
      return;
    }

    const idFactura = jFac.idfacturainfo ?? jFac.id ?? 0;
    if (!idFactura){
      alert('Factura creada sin ID retornado.');
      if (btn) btn.disabled=false; if (estado) estado.textContent=''; 
      return;
    }

    // 2) Guardar vehículos (detalle) - SOLO idfactura, iddatadai, item
    if (vehiculosBuffer.length>0){
      let ok=0, fail=0;
      for (let i = 0; i < vehiculosBuffer.length; i++){
        const v = vehiculosBuffer[i];
        const fdV = new FormData();
        fdV.set('idfactura', String(idFactura));
        if (v.iddatadai!=null) fdV.set('iddatadai', String(v.iddatadai));
        // "item" correlativo: usa v.item si vino, o índice + 1
        const item = Number.isInteger(parseInt(v.item,10)) ? parseInt(v.item,10) : (i+1);
        fdV.set('item', String(item));

        try{
          const r = await fetch('api/facturas_vehiculos_guardar.php', { method:'POST', body: fdV });
          const j = await r.json();
          if (j.success) ok++; else fail++;
        }catch(_){ fail++; }
      }

      // 2.1) Recalcular totales desde lo que REALMENTE se guardó
      try{
        const fdRe = new FormData();
        fdRe.set('idfactura', String(idFactura));
        const rRe  = await fetch('api/facturas_recalcular_totales.php', { method:'POST', body: fdRe });
        const jRe  = await rRe.json();
        if (!jRe.success) {
          console.warn('No se pudo recalcular totales:', jRe.message || jRe);
        }
      }catch(e){
        console.warn('Error llamando a facturas_recalcular_totales:', e);
      }

      if (fail>0) alert(`Factura guardada (ID ${idFactura}). Vehículos ok: ${ok}, fallidos: ${fail}`);
      else alert(`Factura guardada (ID ${idFactura}) con ${ok} vehículo(s).`);
    } else {
      alert(`Factura guardada (ID ${idFactura}). No se agregaron vehículos.`);
    }

    // 3) limpiar/recargar
    const modalEl = document.getElementById('factura_modal');
    const modal = modalEl ? bootstrap.Modal.getInstance(modalEl) : null;
    if (modal) modal.hide();
    resetModal();
    if (tablaFacturas) tablaFacturas.ajax.reload(null,false);
  }catch(e){
    console.error(e); alert('Error de comunicación con el servidor.');
  }finally{
    if (btn) btn.disabled=false; if (estado) estado.textContent='';
  }
}

/* =================== DataTable =================== */
function initTablaFacturas(){
  if (tablaFacturas) return tablaFacturas;

  const z = n => String(n).padStart(2,'0');
  const now = new Date();
  const stamp = `${now.getFullYear()}${z(now.getMonth()+1)}${z(now.getDate())}-${z(now.getHours())}${z(now.getMinutes())}`;
  const filename = `facturas_informativas_${stamp}`;

  tablaFacturas = $('#factura').DataTable({
    ajax: {
      url: 'api/facturas_list.php',
      dataSrc: json => Array.isArray(json) ? json : (json.data || []),
      error: function(xhr, status, err){
        console.error('DataTables AJAX:', status, err, xhr?.responseText);
        const msg = (xhr?.responseJSON?.message) || 'No se pudo cargar el listado.';
        $('#factura tbody').html(
          `<tr><td colspan="8" class="text-center text-danger">${msg}</td></tr>`
        );
      }
    },
    rowId: row => 'fi-' + row.nro,
    deferRender: true,
    processing: true,
    responsive: true,
    stateSave: true,
    pageLength: 25,
    order: [[0, 'desc']],
    
   
    columns: [
      { data: 'nro',          className: 'text-nowrap' },
      { data: 'fecha',        className: 'text-nowrap' },
      { data: 'cliente',      className: 'text-nowrap' },
      { data: 'pedido',       className: 'text-nowrap' },
      { data: 'cod_embarque', className: 'text-nowrap' },
      { data: 'sp',           className: 'text-nowrap' },
      { data: 'dai',          className: 'text-nowrap' },
      { data: 'accion', orderable: false, searchable: false, className: 'text-nowrap text-end' }
    ],
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });

  $.fn.dataTable.ext.errMode = 'none';
  $('#factura').on('error.dt', function(e, settings, techNote, message){
    console.error('DataTables error:', message);
  });

  // Doble click = abrir imprimir
  $('#factura tbody').on('dblclick', 'tr', function(){
    const row = tablaFacturas.row(this).data();
    if (row?.nro) window.open(`factura_ver.php?id=${row.nro}`, '_blank');
  });

  return tablaFacturas;
}

function recargarFacturas(){
  (tablaFacturas || initTablaFacturas()).ajax.reload(null, false);
}

/* =================== Ready / bindings =================== */
document.addEventListener('DOMContentLoaded', () => {
  $.fn.dataTable.ext.errMode = 'none';
  $('#factura').on('error.dt', (_, __, ___, msg) => console.error('DataTables:', msg));
  initTablaFacturas();

  // Modal
  const modalEl = document.getElementById('factura_modal');
  if (modalEl){
    modalEl.addEventListener('show.bs.modal', ()=>{ resetModal(); });
    modalEl.addEventListener('hidden.bs.modal', resetModal);
  }

  // Habilitar bloque al llenar cabecera (solo Cliente/Nombre exonerado)
  document.getElementById('nombre')?.addEventListener('input', ()=> {
    const idc = (document.getElementById('id_cliente')?.value||'').trim();
    if (!idc) { const exo = document.getElementById('exonerado'); if (exo) exo.value = '1'; }
    toggleVehiculosBlock();
  });

  // Empresa
  document.getElementById('btnBuscarRuc')?.addEventListener('click', buscarEmpresa);
  document.getElementById('ruc')?.addEventListener('keydown', (e)=>{ if (e.key==='Enter'){ e.preventDefault(); buscarEmpresa(); }});

  // Botones de chasis
  const btnAgregar = document.getElementById('btnAgregar');
  if (btnAgregar){
    btnAgregar.addEventListener('click', ()=> {
      const inp = document.getElementById('chasis');
      const raw = (inp?.value||'').trim();
      if (!raw){ alert('Ingrese o pegue uno o varios chasis.'); return; }
      procesarInputChasis(raw);
      if (inp) inp.value = '';
    });
  }
  const btnPegarLista = document.getElementById('btnPegarLista');
  if (btnPegarLista){
    btnPegarLista.addEventListener('click', async ()=>{
      let texto = '';
      try{ texto = await navigator.clipboard.readText(); }
      catch{ texto = prompt('Pega aquí tu lista de chasis:') || ''; }
      if (texto.trim()) procesarInputChasis(texto);
    });
  }
  const btnLimpiarTabla = document.getElementById('btnLimpiarTabla');
  if (btnLimpiarTabla){ btnLimpiarTabla.addEventListener('click', ()=>{ vehiculosBuffer = []; renderVehiculosBuffer(); }); }

  // Input chasis: Enter y pegar directo
  const chasisInput = document.getElementById('chasis');
  if (chasisInput){
    chasisInput.addEventListener('keydown', (e)=>{ if (e.key==='Enter'){ e.preventDefault(); btnAgregar ? btnAgregar.click() : agregarVehiculoBuffer(); }});
    chasisInput.addEventListener('paste', (e)=>{
      e.preventDefault();
      const t = (e.clipboardData || window.clipboardData).getData('text') || '';
      if (t.trim()) procesarInputChasis(t);
    });
  }

  // Guardar
  document.getElementById('btnGuardarTodo')?.addEventListener('click', guardarTodo);
});
</script>

<style>
  .dataTables_wrapper .dt-buttons { margin-bottom: .5rem; }
  table.dataTable tbody tr > * { padding-top: .35rem; padding-bottom: .35rem; }
</style>

</body>
</html>
