<?php
// index.php modernizado para SGO
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
	header("Location: ../../views/index.php");
	exit();
}

$usuario = $_SESSION['usuario'];
$permiso = $_SESSION['permiso'];
include("conex.php");
?>
<style>
  #dai {
    font-size: 12px;
  }

  #dai thead th {
    font-size: 12px;
  }

  #dai tbody td {
    font-size: 11px;
  }
</style>

<?php include 'partials/header.php'; ?>

<body>
<div class="container-fluid">
  <div class="row">
  
    <!-- Sidebar -->
    <?php include 'partials/menu.php'; ?>

    <!-- Contenido principal -->
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      
      <!-- Barra superior (topbar) con fondo rojo y reloj en vivo -->
      <?php include 'partials/topbar.php'; ?>

      <div class="row ">
        <div class="col-lg-12 col-md-12">
          <div class="panel panel-WHITE">
            <div class="panel-heading">
              <div class="row">                            
                <div class="row ">                              
                  <div class="col-md-12 col-md-offset-0">
                  </div>
                </div>
                <div  class="col-md-12 col-md-offset-0">    
                  <table id="dai" class="table table-hover" cellspacing="0" width="100%">
                    <thead>
                      <tr class="info">
                        <th>DAI</th>
                        <th>Fecha Inicio</th>
                        <th>Fecha Vencimiento</th>
                        <th>Marca</th>                                      
                        <th>Modelo</th>
                        <th>Nº de Chasis</th>
                        <th>Nº de Motor</th>
                        <th>Color</th>          
                      </tr>
                    </thead>
                    <tbody>
                        <!--en esta area se carga en una matriz la tabla solicitud-->
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>        
      </div>
    </main>
  </div>
</div>
<?php include 'partials/footer.php'; ?>
<script>
  
  $(document).ready(function () {
    $('#dai').DataTable({
    ajax: 'api/dapPatioGuayaquil.php',
    columns: [
      { data: 'dai' },
      { data: 'inicio' },
      { data: 'fin' },
      { data: 'marca' },
      { data: 'modelo' },
      { data: 'chasis' },
      { data: 'motor' },
      { data: 'color' }
    ],
    dom: 'Bfrtip',
    buttons: [
      'copy',
      'excel',
      {
        extend: 'pdfHtml5',
        text: 'PDF',
        orientation: 'landscape', // o 'portrait' si prefieres vertical
        pageSize: 'A4',
        customize: function (doc) {
          doc.styles.tableHeader = {
            bold: true,
            fontSize: 10,
            color: 'black',
            fillColor: '#cccccc',
            alignment: 'center'
          };
          doc.defaultStyle.fontSize = 9;
          doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
        }
      }
      
    ],
    language: {
      url: '../../resources/js/es-ES.json'
    }
  });
});

</script>

</body>
</html>
