<?php
header('Content-Type: application/json');

// Conexión (ajusta la ruta si es necesario)
include("../conex.php");

// Validar que llegó el ID
if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
    echo json_encode([
        'success' => false,
        'error' => 'ID no válido o no recibido'
    ]);
    exit;
}

$id = (int) $_POST['id'];

// Ejecutar UPDATE con seguridad
$sql = "UPDATE tb_datadai SET condicion = 0 WHERE iddatadai = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        'success' => false,
        'error' => 'Error en la preparación de la consulta: ' . $conn->error
    ]);
    exit;
}

$stmt->bind_param("i", $id);
$success = $stmt->execute();

// Retornar resultado
echo json_encode([
    'success' => $success,
    'id_afectado' => $id
]);

$stmt->close();
$conn->close();
