<?php
// index.php — SGO · Módulo de Asignación de Transporte (con multibúsqueda de chasis)
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php");
  exit();
}
$usuario = $_SESSION['usuario'] ?? 'Invitado';
$permiso = $_SESSION['permiso'] ?? 0;
require_once __DIR__ . '/conex.php';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>SGO · Asignación Transporte</title>

  <!-- Bootstrap 5 CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <!-- DataTables + Bootstrap 5 CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

  <style>
    #asigna { font-size: 12px; }
    #asigna thead th { font-size: 12px; }
    #asigna tbody td { font-size: 11px; }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <?php include 'partials/menu.php'; ?>

    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <?php include 'partials/topbar.php'; ?>

      <div class="row">
        <div class="col-12">
          <div class="panel panel-WHITE">
            <div class="panel-heading">
              <button id="btnAsignarTransporte" class="btn btn-primary mb-2" disabled>
                <i class="fa fa-truck"></i> Asignar Transporte
              </button>

              <div class="table-responsive">
                <table id="asigna" class="table table-hover table-sm w-100">
                  <thead>
                    <tr>
                      <th class="text-center"><input type="checkbox" id="checkAll" style="width:18px;height:18px"></th>
                      <th>Chasis</th>
                      <th>Color</th>
                      <th>Modelo</th>
                      <th>Marca</th>
                      <th>Pedido</th>
                      <th>Localidad</th>
                      <th>Destino</th>
                      <th>Transportista</th>
                      <th>Status</th>
                      <th></th>
                    </tr>
                  </thead>
                  <tbody><!-- dinámico --></tbody>
                </table>
              </div>

            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<!-- Modal de Asignación -->
<div class="modal fade" id="modalAsignar" tabindex="-1" aria-labelledby="modalAsignarLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="formAsignar">
        <div class="modal-header">
          <h5 class="modal-title" id="modalAsignarLabel">Asignar Transporte</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Empresa de Transporte</label>
            <select id="empresa" class="form-select" required>
              <option value="">Cargando empresas...</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Destino</label>
            <select id="destino" class="form-select" required>
              <option value="">Cargando destinos...</option>
            </select>
          </div>

          <div class="d-flex justify-content-between align-items-center mb-2">
            <span>Vehículos: <span class="badge bg-primary" id="contadorVehiculos">0</span></span>
            <button type="button" id="btnVaciarLista" class="btn btn-outline-danger btn-sm">
              <i class="fa fa-trash"></i> Vaciar lista
            </button>
          </div>

          <div class="table-responsive">
            <table class="table table-sm table-bordered mb-0" id="listaChasis">
              <thead class="table-light">
                <tr>
                  <th>Chasis</th><th>Color</th><th>Modelo</th><th>Marca</th><th class="text-center">Acción</th>
                </tr>
              </thead>
              <tbody><!-- dinámico --></tbody>
            </table>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success" disabled>Guardar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- ==== JS ==== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- DataTables core + Bootstrap integration -->
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<!-- Buttons + deps (Excel/PDF) -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.10/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.10/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<!-- Responsive -->
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(function(){
  // ====== Inicialización de DataTable ======
  const dt = $('#asigna').DataTable({
    ajax: 'api/dai_asigna.php',
    columns: [
      { data:'check', orderable:false, searchable:false },
      { data:'chasis' },
      { data:'color' },
      { data:'modelo' },
      { data:'marca' },
      { data:'pedido' },
      { data:'localidad' },
      { data:'destino' },
      { data:'transportista' },
      { data:'status' },
      { data:'accion', orderable:false, searchable:false }
    ],
    dom: '<"top"B><"bottom"l>frtip', // Botones arriba, selector abajo
     lengthMenu: [
      [10, 25, 50, 100, -1],
      [10, 25, 50, 100, "Todos"]
    ],

    buttons: [
      'copy',
      'excel',
      {
        extend:'pdfHtml5', text:'PDF', orientation:'landscape', pageSize:'A4',
        customize: function(doc){ doc.defaultStyle.fontSize = 9; }
      }
    ],
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' },
    responsive: true,

    // --- Aquí enganchamos la búsqueda múltiple cuando la tabla ya está lista ---
    initComplete: function(){
      const api = this.api();
      hookMultiChasis(api);    // <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      wireSelectionButtons();  // checkbox y botón asignar
    }
  });

  // ====== BÚSQUEDA MÚLTIPLE DE CHASIS (en initComplete) ======
  function hookMultiChasis(api){
    const CHASIS_COL_INDEX = 1; // 0=checkbox, 1=Chasis
    const $input = $('#asigna_filter input[type="search"]');

    // placeholder amigable
    $input.attr('placeholder','Buscar chasis — pega varios separados por espacio, coma o ;');

    // Mantén referencia al filtro activo para poder quitarlo
    let activeFilter = null;

    // Debounce simple
    let t = null;
    $input.off('.multichasis').on('input.multichasis keyup.multichasis paste.multichasis', function(){
      clearTimeout(t);
      t = setTimeout(applyFilter, 140);
    });

    function removeActiveFilter(){
      if (!activeFilter) return;
      const idx = $.fn.dataTable.ext.search.indexOf(activeFilter);
      if (idx > -1) $.fn.dataTable.ext.search.splice(idx, 1);
      activeFilter = null;
    }

    function applyFilter(){
      const raw = ($input.val() || '').trim();

      if (!raw){
        removeActiveFilter();
        api.search('');                    // limpia global
        api.column(CHASIS_COL_INDEX).search(''); // limpia columna
        api.draw();
        return;
      }

      // Trocea en tokens minúsculos
      const tokens = raw.split(/[\s,;]+/)
                        .map(t => t.trim().toLowerCase())
                        .filter(Boolean);

      if (tokens.length === 1){
        // Un término → usa búsqueda en columna chasis (más rápida)
        removeActiveFilter();
        api.search(''); // limpia global
        api.column(CHASIS_COL_INDEX).search(tokens[0], false, true); // contiene
        api.draw();
        return;
      }

      // Varios términos → filtro personalizado "contiene cualquiera"
      api.search('');
      api.column(CHASIS_COL_INDEX).search('');
      removeActiveFilter();

      activeFilter = function(settings, data){
        if (settings.nTable !== api.table().node()) return true; // solo esta tabla
        const chasis = (data[CHASIS_COL_INDEX] || '').toString().toLowerCase();
        return tokens.some(t => chasis.includes(t));
      };
      $.fn.dataTable.ext.search.push(activeFilter);
      api.draw();
    }
  }

  // ====== Selección y acciones (checkbox maestro / modal / guardar) ======
  function wireSelectionButtons(){
    // Checkbox maestro
    $(document).on('change', '#checkAll', function(){
      $('.check-row').prop('checked', this.checked);
      toggleBtnAsignar();
    });

    // Checkbox individuales
    $(document).on('change', '.check-row', function(){
      const total = $('.check-row').length;
      const marcados = $('.check-row:checked').length;
      $('#checkAll').prop('checked', total > 0 && marcados === total);
      toggleBtnAsignar();
    });

    function toggleBtnAsignar(){
      $('#btnAsignarTransporte').prop('disabled', $('.check-row:checked').length === 0);
    }

    // Abrir modal
    $('#btnAsignarTransporte').on('click', async function () {
      await Promise.all([cargarEmpresas(), cargarDestinos()]);
      const tb = $('#listaChasis tbody').empty();

      $('.check-row:checked').each(function(){
        tb.append(`
          <tr data-id="${$(this).val()}">
            <td>${$(this).data('chasis') || ''}</td>
            <td>${$(this).data('color') || ''}</td>
            <td>${$(this).data('modelo') || ''}</td>
            <td>${$(this).data('marca') || ''}</td>
            <td class="text-center">
              <button class="btn btn-sm btn-danger btn-eliminar" type="button" title="Quitar"><i class="fa fa-trash"></i></button>
            </td>
          </tr>`);
      });

      actualizarContador();
      new bootstrap.Modal('#modalAsignar').show();
    });

    // Quitar fila del modal
    $(document).on('click', '.btn-eliminar', function(){
      $(this).closest('tr').remove();
      actualizarContador();
    });

    // Vaciar lista
    $('#btnVaciarLista').on('click', function(){
      Swal.fire({
        title:'¿Vaciar lista?', text:'Se eliminarán todos los vehículos seleccionados.',
        icon:'warning', showCancelButton:true, confirmButtonText:'Sí, vaciar', cancelButtonText:'Cancelar'
      }).then(r=>{
        if(r.isConfirmed){
          $('#listaChasis tbody').empty();
          actualizarContador();
        }
      });
    });

    function actualizarContador(){
      const t = $('#listaChasis tbody tr').length;
      $('#contadorVehiculos').text(t);
      $('#formAsignar button[type="submit"]').prop('disabled', t === 0);
    }

    // Guardar asignación
    $('#formAsignar').on('submit', async function(e){
      e.preventDefault();

      const empresa = Number($('#empresa').val() || 0);
      const destino = Number($('#destino').val() || 0);
      const ids = $('#listaChasis tbody tr').map(function(){ return Number($(this).data('id') || 0); }).get();
      const seleccionados = [...new Set(ids.filter(n => n > 0))];

      if (!empresa || !destino || seleccionados.length === 0){
        Swal.fire('Atención','Complete todos los campos y seleccione al menos un vehículo.','warning');
        return;
      }

      try{
        const res = await fetch('controllers/asignar_transporte.php', {
          method:'POST',
          headers:{ 'Content-Type':'application/json' },
          body: JSON.stringify({ empresa, destino, seleccionados })
        });

        const text = await res.text();
        let data = null; try { data = JSON.parse(text); } catch(_){}

        if (!res.ok) {
          const msg = (data && (data.detail || data.message)) || (text && text.trim()) || `HTTP ${res.status}`;
          throw new Error(msg);
        }
        if (!data || data.success !== true) {
          const msg = (data && (data.detail || data.message)) || (text && text.trim()) || 'Operación rechazada';
          throw new Error(msg);
        }

        let msg = `Vehículos asignados.<br><b>Insertados:</b> ${data.insertados ?? 0}`;
        if ((data.omitidos ?? 0) > 0) msg += `<br><b>Omitidos:</b> ${data.omitidos}`;
        if (Array.isArray(data.duplicados) && data.duplicados.length) {
          msg += `<br><small>Duplicados: ${data.duplicados.join(', ')}</small>`;
        }
        msg += data.email_sent ? `<br><b>Correo:</b> enviado ✅`
                               : `<br><b>Correo:</b> NO enviado${data.email_error ? ' — ' + data.email_error : ''}`;

        Swal.fire({ icon:'success', title:'Asignación completada', html: msg });

        // Cerrar modal y refrescar tabla
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalAsignar'));
        if (modal) modal.hide();
        $('#checkAll').prop('checked', false);
        $('.check-row').prop('checked', false);
        $('#btnAsignarTransporte').prop('disabled', true);
        $('#asigna').DataTable().ajax.reload(null, false);

      } catch(err){
        console.error(err);
        Swal.fire('No se asignó', err.message || 'Sin detalle', 'warning');
      }
    });

    // Cargar selects
    function cargarEmpresas(){
      return fetch('api/transportes_activos.php')
        .then(r=>r.json())
        .then(d=>{
          const $s = $('#empresa').empty().append('<option value="">Seleccione...</option>');
          (d||[]).forEach(x=>$s.append(`<option value="${x.id}">${x.nombre}</option>`));
        })
        .catch(_=>$('#empresa').html('<option value="">Error al cargar</option>'));
    }
    function cargarDestinos(){
      return fetch('api/destinos_activos.php')
        .then(r=>r.json())
        .then(d=>{
          const $s = $('#destino').empty().append('<option value="">Seleccione...</option>');
          (d||[]).forEach(x=>$s.append(`<option value="${x.id}">${x.nombre}</option>`));
        })
        .catch(_=>$('#destino').html('<option value="">Error al cargar</option>'));
    }
  }
});
</script>
</body>
</html>
