<?php
// api/medida_capacidad_list.php
declare(strict_types=1);
session_start();

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

// ⬇️ Ajusta la ruta a tu archivo de conexión
require_once __DIR__ . '/../conex.php';

// Soporta $conn o $conex
$db = $conn ?? ($conex ?? null);
if (!$db) {
  http_response_code(500);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['success' => false, 'message' => 'Sin conexión a la base de datos']);
  exit;
}

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

// Parámetros
$q                = trim((string)($_GET['q'] ?? ''));            // buscar por texto en "medida"
$limit            = (int)($_GET['limit'] ?? 100);                // límite (1..500)
if ($limit <= 0 || $limit > 500) $limit = 100;
$include_inactive = (int)($_GET['include_inactive'] ?? 0) === 1; // incluir inactivos
$mode             = $_GET['mode'] ?? 'json';                     // 'json' | 'options'
$selected         = isset($_GET['selected']) ? (int)$_GET['selected'] : 0; // para 'options'

// Detectar nombre de columna: condicion | codicion
$condCol = 'condicion';
$colRes  = mysqli_query($db, "SHOW COLUMNS FROM tb_medida_capacidad LIKE 'condicion'");
if (!$colRes || mysqli_num_rows($colRes) === 0) {
  $condCol = 'codicion';
  $colRes2 = mysqli_query($db, "SHOW COLUMNS FROM tb_medida_capacidad LIKE 'codicion'");
  if (!$colRes2 || mysqli_num_rows($colRes2) === 0) {
    $condCol = null; // ninguna existe, no filtrar por estado
  }
}

// Construir WHERE
$where  = '1';
$params = [];
$types  = '';

if (!$include_inactive && $condCol) {
  $where .= " AND `$condCol` = 1";
}
if ($q !== '') {
  $where .= " AND medida LIKE ?";
  $params[] = "%$q%";
  $types   .= 's';
}

$sql = "SELECT id, medida
        FROM tb_medida_capacidad
        WHERE $where
        ORDER BY medida ASC
        LIMIT ?";
$params[] = $limit;
$types   .= 'i';

// Ejecutar
$stmt = mysqli_prepare($db, $sql);
if (!$stmt) {
  http_response_code(500);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['success' => false, 'message' => 'Error preparando consulta']);
  exit;
}
mysqli_stmt_bind_param($stmt, $types, ...$params);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$rows = [];
if ($res) {
  while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = ['id' => (int)$r['id'], 'medida' => (string)$r['medida']];
  }
}
mysqli_stmt_close($stmt);

// Salidas
if ($mode === 'options') {
  header('Content-Type: text/html; charset=utf-8');
  $out = '<option value="">Seleccione…</option>';
  foreach ($rows as $r) {
    $sel = ($selected > 0 && $selected === (int)$r['id']) ? ' selected' : '';
    $out .= '<option value="'.$r['id'].'"'.$sel.'>'.htmlspecialchars($r['medida'], ENT_QUOTES, 'UTF-8').'</option>';
  }
  echo $out;
  exit;
}

// Por defecto JSON
header('Content-Type: application/json; charset=utf-8');
echo json_encode(['success' => true, 'count' => count($rows), 'data' => $rows], JSON_UNESCAPED_UNICODE);
