<?php
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

// ===== Cabeceras JSON + CORS =====
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

// ===== Errores como JSON =====
ini_set('display_errors', '0');
error_reporting(E_ALL);
set_error_handler(function($s,$m,$f,$l){
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'PHP error','detail'=>"$m in $f:$l"], JSON_UNESCAPED_UNICODE);
    exit;
});
set_exception_handler(function($e){
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Exception','detail'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
    exit;
});

require '../conex.php'; // conexión MySQL ($conn)

// ===== Entrada =====
$input  = $_SERVER['REQUEST_METHOD']==='POST'
    ? (json_decode(file_get_contents('php://input'), true) ?? $_POST)
    : $_GET;

$chasis = trim($input['chasis'] ?? '');
$exact  = filter_var($input['exact'] ?? false, FILTER_VALIDATE_BOOLEAN);
$limit  = isset($input['limit']) ? max(1, min(100, (int)$input['limit'])) : 50;

if ($chasis === '') {
    http_response_code(400);
    echo json_encode(['success'=>false,'message'=>'Falta el parámetro chasis'], JSON_UNESCAPED_UNICODE);
    exit;
}

// ===== Query =====
$sql = "SELECT 
            d.iddatadai, d.motor, d.marca, d.modelo, d.otras, d.color, d.chasis, 
            d.id_estado, d.dai as regimen, d.origen_localidad, b.detalle, em.razon_social,
            sp.id_empresa
        FROM tb_datadai AS d
        INNER JOIN tb_solicitudprevia AS sp ON sp.idsolicitudprevia = d.id_solicitudprevia
        INNER JOIN tb_empresa AS em ON em.idempresa = sp.id_empresa
        INNER JOIN tb_bodega AS b ON b.idbodega = d.id_bodega
        WHERE d.condicion = 1 AND ";

if ($exact) {
    $sql .= "d.chasis = ? ";
    $bind1 = $chasis;
} else {
    $sql .= "d.chasis LIKE ? ";
    $bind1 = "%{$chasis}%";
}

$sql .= "ORDER BY d.iddatadai DESC LIMIT ?";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    throw new Exception('No se pudo preparar la consulta: ' . $conn->error);
}

$stmt->bind_param('si', $bind1, $limit);
$stmt->execute();
$res  = $stmt->get_result();
$data = $res->fetch_all(MYSQLI_ASSOC);

// Respuesta
echo json_encode([
    'success' => true,
    'count'   => count($data),
    'data'    => $data
], JSON_UNESCAPED_UNICODE);

// Limpieza
$stmt->close();
$conn->close();
