<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *'); // Permitir peticiones externas

require __DIR__ . '/conex.php'; // tu archivo de conexión a BD

if (!$conn instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error de conexión a BD']); 
  exit;
}

try {
    // Solo bancos activos y con condición válida
    $sql = "SELECT id, banco 
            FROM tb_banco 
            WHERE activo = 1 AND condicion = 1
            ORDER BY banco ASC";

    $res = $conn->query($sql);
    $data = [];

    while ($row = $res->fetch_assoc()) {
        $data[] = [
            'value' => $row['id'],
            'label' => $row['banco']
        ];
    }

    echo json_encode(['success'=>true, 'data'=>$data], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success'=>false,
        'message'=>'Error en la consulta',
        'detail'=>$e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
