<?php
// api/vehiculo_por_chasis.php — Busca vehículo por chasis
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

/*
  Requisitos:
  - Sesión válida (ingreso = YES)
  - GET ?chasis=XXXX
  - Devuelve: { success: true, vehiculo:{marca, modelo, color} } o { success:false, message }
*/

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false, 'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { http_response_code(500); echo json_encode(['success'=>false, 'message'=>'Sin conexión a BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

$id_usuario = (int)($_SESSION['idusuario'] ?? 0);
$chasis     = strtoupper(trim((string)($_GET['chasis'] ?? '')));

if ($chasis === '') {
  http_response_code(422);
  echo json_encode(['success'=>false, 'message'=>'Parámetro chasis requerido']); exit;
}

/* (Opcional) Filtrar por bodega del usuario */
$colBod = null;
$us = mysqli_prepare($db, "SELECT id_bodega FROM tb_usuario WHERE idusuario=? LIMIT 1");
if ($us) { mysqli_stmt_bind_param($us,'i',$id_usuario); mysqli_stmt_execute($us); $r= mysqli_stmt_get_result($us); $rw = mysqli_fetch_assoc($r); $colBod = $rw['id_bodega'] ?? null; }

/* Busca el vehículo */
$sql = "SELECT marca, modelo, color
        FROM tb_datadai
        WHERE chasis = ?
          AND condicion = 1
        ".($colBod ? " AND id_bodega = ?" : "")."
        LIMIT 1";
$stmt = mysqli_prepare($db, $sql);
if (!$stmt) { http_response_code(500); echo json_encode(['success'=>false, 'message'=>'Error preparando SQL']); exit; }

if ($colBod) {
  mysqli_stmt_bind_param($stmt, 'si', $chasis, $colBod);
} else {
  mysqli_stmt_bind_param($stmt, 's', $chasis);
}
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);

if (!$row) {
  http_response_code(404);
  echo json_encode(['success'=>false, 'message'=>'Chasis no encontrado']); exit;
}

echo json_encode([
  'success'  => true,
  'vehiculo' => [
    'marca'  => (string)($row['marca']  ?? ''),
    'modelo' => (string)($row['modelo'] ?? ''),
    'color'  => (string)($row['color']  ?? ''),
  ]
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
