<?php
// api/taller_list.php — Lista de talleres activos
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') { http_response_code(401); echo json_encode(['success'=>false,'data'=>[], 'message'=>'No autorizado']); exit; }

$pathConex = realpath(__DIR__ . '/../conex.php') ?: realpath(__DIR__ . '/../../conex.php') ?: realpath(__DIR__ . '/conex.php');
if (!$pathConex) { http_response_code(500); echo json_encode(['success'=>false,'data'=>[], 'message'=>'No se encontró conex.php']); exit; }
require_once $pathConex;
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { http_response_code(500); echo json_encode(['success'=>false,'data'=>[], 'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');

$sql = "SELECT idtaller, taller FROM tb_taller WHERE condicion=1 ORDER BY taller";
$res = $db->query($sql);
$data = [];
if ($res) { while ($r = $res->fetch_assoc()) { $data[] = ['idtaller'=>(int)$r['idtaller'], 'taller'=>$r['taller']]; } }

echo json_encode(['success'=>true, 'data'=>$data]);
