<?php
// api/regimen_list.php — Lista de regímenes para el combo
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['data'=>[], 'message'=>'Sin conexión a BD']); exit;
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/*
  Si tienes tabla de regímenes, ejemplo:
  CREATE TABLE tb_regimen (
    idregimen INT PRIMARY KEY AUTO_INCREMENT,
    detalle   VARCHAR(100) NOT NULL,
    condicion TINYINT NOT NULL DEFAULT 1
  );
*/
$data = [];
$sql  = "SELECT idregimen AS id, detalle FROM tb_regimen WHERE condicion=1 ORDER BY detalle";
$q    = mysqli_query($db, $sql);

if ($q) {
  while ($r = mysqli_fetch_assoc($q)) {
    $data[] = ['id' => (int)$r['id'], 'detalle' => (string)$r['detalle']];
  }
}

/* Fallback si no hay tabla o está vacía */
if (!$q || !$data) {
  $data = [
    ['id' => 1, 'detalle' => 'DAP'],
    ['id' => 2, 'detalle' => 'SIMPLE'],
  ];
}

echo json_encode(['data' => $data], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
