<?php
// lavada_upsert.php — UPSERT por id_datadai (1 fila por vehículo)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$idpdi  = (int)($in['idpdi'] ?? 0);
$idtipo = (int)($in['idtipo_lavada'] ?? 0);
$idUsuario = (int)($_SESSION['idusuario'] ?? 0); // ajusta a tu sesión

if ($idpdi <= 0 || $idtipo <= 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}

$stVal = $db->prepare("SELECT COUNT(*) c FROM tb_tipolavada WHERE idtipo_lavada=? AND condicion=1");
$stVal->bind_param('i', $idtipo);
$stVal->execute();
if (!((int)$stVal->get_result()->fetch_assoc()['c'])) {
  echo json_encode(['success'=>false,'message'=>'Tipo de lavada inválido']); exit;
}

$stP = $db->prepare("SELECT id_datadai FROM tb_pdi WHERE idpdi=? AND condicion=1");
$stP->bind_param('i', $idpdi);
$stP->execute();
$row = $stP->get_result()->fetch_assoc();
if (!$row) { echo json_encode(['success'=>false,'message'=>'Requerimiento no encontrado']); exit; }
$idDatadai = (int)$row['id_datadai'];

$db->begin_transaction();

// 1) Leer valor actual (si existe)
$cur = null;
$stCur = $db->prepare("SELECT id_tipolavada FROM tb_lavada WHERE id_datadai=? LIMIT 1");
$stCur->bind_param('i', $idDatadai);
$stCur->execute();
$rCur = $stCur->get_result()->fetch_assoc();
if ($rCur) $cur = (int)$rCur['id_tipolavada'];

// 2) Si es el mismo, no hacemos nada
if ($cur !== null && $cur === $idtipo) {
  $db->commit();
  echo json_encode(['success'=>true,'action'=>'noop','message'=>'Sin cambios']); exit;
}

// 3) UPSERT
$sql = "
  INSERT INTO tb_lavada (id_datadai, fecha_registro, id_tipolavada, id_usuario, condicion)
  VALUES (?, NOW(), ?, ?, 1)
  ON DUPLICATE KEY UPDATE
    id_tipolavada = VALUES(id_tipolavada),
    id_usuario    = VALUES(id_usuario),
    condicion     = 1,
    fecha_registro= NOW()
";
$st = $db->prepare($sql);
$st->bind_param('iii', $idDatadai, $idtipo, $idUsuario);
if (!$st->execute()) {
  $db->rollback();
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'No se pudo guardar','sql_error'=>$db->error]); exit;
}

$db->commit();

// Interpretar affected_rows: 1 insert, 2 update, 0 (no cambia)
$aff = $db->affected_rows;
$action = $aff === 1 ? 'insert' : ($aff === 2 ? 'update' : 'noop');

echo json_encode(['success'=>true,'action'=>$action]);
