<?php
// lavada_insert.php — inserta historial de lavada en tb_lavada (idempotente por último valor)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

$raw = file_get_contents('php://input');
$in  = json_decode($raw, true) ?: [];

$idpdi  = (int)($in['idpdi'] ?? 0);
$idtipo = (int)($in['idtipo_lavada'] ?? 0);

// Ajusta según tu sesión (int/varchar). Si usas string, cambia el tipo de columna / bind.
$idUsuario = (int)($_SESSION['idusuario'] ?? 0);

if ($idpdi <= 0 || $idtipo <= 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}

// Validar tipo de lavada activo
$stVal = $db->prepare("SELECT COUNT(*) c FROM tb_tipolavada WHERE idtipo_lavada=? AND condicion=1");
$stVal->bind_param('i', $idtipo);
$stVal->execute();
$c = (int)$stVal->get_result()->fetch_assoc()['c'];
if ($c === 0) { echo json_encode(['success'=>false,'message'=>'Tipo de lavada inválido']); exit; }

// Obtener id_datadai desde tb_pdi
$stDat = $db->prepare("SELECT id_datadai FROM tb_pdi WHERE idpdi=? AND condicion=1");
$stDat->bind_param('i', $idpdi);
$stDat->execute();
$row = $stDat->get_result()->fetch_assoc();
if (!$row) { echo json_encode(['success'=>false,'message'=>'Requerimiento no encontrado']); exit; }
$idDatadai = (int)$row['id_datadai'];

// Verificar última lavada (idempotencia)
$stUlt = $db->prepare("
  SELECT id_tipolavada 
  FROM tb_lavada 
  WHERE id_datadai=? AND condicion=1
  ORDER BY fecha_registro DESC, idlavada DESC
  LIMIT 1
");
$stUlt->bind_param('i', $idDatadai);
$stUlt->execute();
$prev = $stUlt->get_result()->fetch_assoc();
if ($prev && (int)$prev['id_tipolavada'] === $idtipo) {
  // Nada cambia: no insertamos otro registro duplicado consecutivo
  echo json_encode([
    'success'=>true,
    'inserted'=>0,
    'reason'=>'sin_cambios',
    'message'=>'El tipo de lavada ya es el último registrado'
  ]);
  exit;
}

// Insertar nueva lavada
$ins = $db->prepare("
  INSERT INTO tb_lavada (id_datadai, fecha_registro, id_tipolavada, id_usuario, condicion)
  VALUES (?, NOW(), ?, ?, 1)
");
$ins->bind_param('iii', $idDatadai, $idtipo, $idUsuario);

if (!$ins->execute()) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'No se pudo guardar','sql_error'=>$db->error]); exit;
}

echo json_encode([
  'success'=>true,
  'inserted'=>1,
  'idlavada'=>$db->insert_id,
  'message'=>'Lavada registrada'
]);
