<?php
// api/datadai_delete.php — borrado lógico de una fila de tb_datadai
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['success'=>false,'message'=>'Método no permitido']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }
mysqli_set_charset($db, 'utf8mb4');

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

$sql = "UPDATE tb_datadai SET condicion = 0 WHERE iddatadai = ?";
$stmt = $db->prepare($sql);
if (!$stmt) { echo json_encode(['success'=>false,'message'=>'Prepare: '.mysqli_error($db)]); exit; }

$stmt->bind_param('i', $id);
$ok = $stmt->execute();

echo json_encode($ok
  ? ['success'=>true, 'message'=>'Eliminado correctamente']
  : ['success'=>false,'message'=>'No se pudo eliminar: '.$stmt->error]
);
