<?php
// api/categoria_toggle.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
if (!isset($conn) || !($conn instanceof mysqli)) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión a BD']); exit;
}
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id = (int)($in['id_categoria'] ?? 0);
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

/** Alternativas que corrigen NULL:
 * 1) condicion = 1 - IFNULL(condicion,0)
 * 2) CASE WHEN condicion IS NULL OR condicion=0 THEN 1 ELSE 0 END
 */
$sql = "UPDATE tb_inv_categoria 
        SET condicion = 1 - IFNULL(condicion,0)
        WHERE id_categoria = ?";

$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'i', $id);
$ok = mysqli_stmt_execute($stmt);

if (!$ok) {
  echo json_encode(['success'=>false,'message'=>'No se pudo cambiar estado']); exit;
}
if (mysqli_affected_rows($conn) === 0) {
  echo json_encode(['success'=>false,'message'=>'No se encontró el registro']); exit;
}

/* Devuelve el nuevo estado para actualizar UI sin recargar todo si quisieras */
$sel = mysqli_prepare($conn, "SELECT id_categoria, IFNULL(condicion,0) AS condicion FROM tb_inv_categoria WHERE id_categoria=?");
mysqli_stmt_bind_param($sel, 'i', $id);
mysqli_stmt_execute($sel);
$res = mysqli_stmt_get_result($sel);
$row = mysqli_fetch_assoc($res) ?: ['id_categoria'=>$id,'condicion'=>null];

echo json_encode(['success'=>true,'message'=>'Estado actualizado','data'=>$row]);
