<?php
// alistamiento_list.php — lista para DataTable con última lavada
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['data'=>[], 'success'=>false, 'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['data'=>[], 'success'=>false, 'message'=>'Sin conexión']); exit; }

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

/*
  Tablas:
  - tb_datadai(iddatadai, marca, modelo, color, chasis, condicion)
  - tb_pdi(idpdi, id_datadai, alistamiento, fecha_req, fecha_ent, prioridad, facturado, condicion)
  - tb_lavada(idlavada, id_datadai, fecha_registro, id_tipolavada, id_usuario, condicion)
  - tb_tipolavada(idtipo_lavada, lavada, condicion)
*/
$sql = "
  WITH ultima_lavada AS (
    SELECT l1.id_datadai, l1.id_tipolavada
    FROM tb_lavada l1
    INNER JOIN (
      SELECT id_datadai, MAX(fecha_registro) AS max_fecha
      FROM tb_lavada
      WHERE condicion = 1
      GROUP BY id_datadai
    ) lm ON lm.id_datadai = l1.id_datadai AND lm.max_fecha = l1.fecha_registro
    WHERE l1.condicion = 1
  )
  SELECT
    p.idpdi,
    d.marca,
    d.modelo,
    d.color,
    d.chasis,
    p.lugar,
    p.alistamiento,
    DATE_FORMAT(p.fecha_req, '%Y-%m-%d %H:%i') AS fecha_req,
    DATE_FORMAT(p.fecha_ent, '%Y-%m-%d %H:%i') AS fecha_ent,
    p.prioridad,
    p.facturado,
    ul.id_tipolavada AS idtipo_lavada,
    tl.lavada
  FROM tb_pdi p
  INNER JOIN tb_datadai d ON d.iddatadai = p.id_datadai
  LEFT JOIN ultima_lavada ul ON ul.id_datadai = d.iddatadai
  LEFT JOIN tb_tipolavada tl ON tl.idtipo_lavada = ul.id_tipolavada AND tl.condicion = 1
  WHERE p.condicion = 1
  ORDER BY p.fecha_req DESC, p.idpdi DESC
  LIMIT 2000
";

$res = $db->query($sql);
$data = [];
if ($res) { while ($row = $res->fetch_assoc()) { $data[] = $row; } }
else { echo json_encode(['data'=>[], 'success'=>false, 'message'=>'Error de consulta', 'sql_error'=>$db->error]); exit; }

echo json_encode(['data'=>$data, 'success'=>true]);
