<?php
// api/accesorizacion_opciones.php
// Salida: { success:true, data:[{id:"1", nombre:"Alarma"}, ...] }
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require_once __DIR__ . '/../conex.php';

try{
  if (!isset($conn) || !($conn instanceof mysqli)) throw new RuntimeException('Sin conexión BD');
  mysqli_set_charset($conn,'utf8mb4');

  // Catálogo: tb_accesorios(idaccesorios, detalle, condicion)
  $sql = "SELECT idaccesorios AS id, detalle AS nombre
          FROM tb_accesorios
          WHERE condicion = 1
          ORDER BY detalle ASC";
  $rs = mysqli_query($conn,$sql);

  $data=[];
  while($r=mysqli_fetch_assoc($rs)){
    $data[] = ['id'=>(string)$r['id'], 'nombre'=>(string)$r['nombre']];
  }

  echo json_encode(['success'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);
}catch(Throwable $e){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
