<?php
// api/accesorizacion_list_min.php — Lista para DataTable con accesorios concatenados por " - "
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../conex.php';

try {
    if (!isset($conn) || !($conn instanceof mysqli)) {
        throw new RuntimeException('Sin conexión BD');
    }

    // Configuración base
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
    mysqli_set_charset($conn, 'utf8mb4');
    date_default_timezone_set('America/Guayaquil');

    // Límite opcional (?limit=1000)
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 500;
    if ($limit < 1)    $limit = 1;
    if ($limit > 5000) $limit = 5000;

    // Consulta: fecha_programada = fecha_ingreso o hoy; accesorios concatenados con " - "
    $sql = "
        SELECT
            d.iddatadai,
            d.marca,
            d.modelo,
            d.chasis,
            d.color,
            DATE_FORMAT(COALESCE(d.fecha_ingreso, NOW()), '%Y-%m-%d') AS fecha_programada,
            COALESCE((
                SELECT GROUP_CONCAT(DISTINCT acc.detalle ORDER BY acc.detalle SEPARATOR ' - ')
                FROM tb_accesorizacion AS a2
                INNER JOIN tb_accesorios   AS acc ON acc.idaccesorios = a2.id_accesorios
                WHERE a2.id_datadai = d.iddatadai
                  AND a2.estado_acces = 1
            ), '') AS accesorios
        FROM tb_datadai AS d
        WHERE d.condicion = 1
          AND (d.dai = 'Simple' OR d.dai IS NULL)
        ORDER BY fecha_programada DESC
        LIMIT {$limit}
    ";

    $rs = $conn->query($sql);

    $data = [];
    while ($r = $rs->fetch_assoc()) {
        $data[] = [
            'marca'            => (string)($r['marca'] ?? ''),
            'modelo'           => (string)($r['modelo'] ?? ''),
            'chasis'           => (string)($r['chasis'] ?? ''),
            'color'            => (string)($r['color'] ?? ''),
            'fecha_programada' => (string)($r['fecha_programada'] ?? ''),
            'accesorios'       => (string)($r['accesorios'] ?? ''), // ahora separados por " - "
        ];
    }

    echo json_encode(['data' => $data], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['data' => [], 'error' => $e->getMessage()]);
}
