<?php
// accesorios.php — SGO · Inventario · Accesorios
declare(strict_types=1);
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = (int)($_SESSION['permiso'] ?? 0);
?>
<?php include __DIR__ . '/partials/header.php'; ?>
<!doctype html>
<html lang="es" data-theme="light">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>SGO · Inventario · Accesorios</title>

  <!-- CSS (quita si ya se cargan en header.php) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" referrerpolicy="no-referrer" />
  <link href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-bootstrap-4@5/bootstrap-4.min.css" rel="stylesheet">

  <style>
    :root { font-size: 15.5px; }
    .dt-center { text-align:center; }
    html, body, .container-fluid, .row { height: 100%; }
    .flex-fill { min-height: 0; }
    #workArea, #tableWrap { min-height: 0; padding: 0; }
    .dataTables_wrapper { padding: 0; }
    html[data-theme="dark"] body { background:#0f1115; color:#e7e7e7; }
    html[data-theme="dark"] .table { color:#e7e7e7; }
    html[data-theme="dark"] .table thead th { color:#f0f0f0; }
    .mono { font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace; }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <?php include __DIR__ . '/partials/menu.php'; ?>

    <main class="col-md-9 ms-sm-auto col-lg-10 px-0 d-flex flex-column">
      <?php include __DIR__ . '/partials/topbar.php'; ?>

      <section id="workArea" class="flex-fill d-flex flex-column">
        <div id="toolbar" class="d-flex flex-wrap align-items-center gap-2 px-3 py-2 border-bottom">
          <h6 class="mb-0"><i class="fa-solid fa-toolbox me-2"></i> Accesorios</h6>
          <select id="fCategoria" class="form-select form-select-sm" style="width:240px">
            <option value="">— Todas las categorías —</option>
          </select>
          <select id="fEstado" class="form-select form-select-sm" style="width:160px">
            <option value="0">— Todos —</option>
            <option value="1">Sólo habilitados</option>
          </select>
          <input id="txtBuscar" class="form-control form-control-sm" placeholder="Buscar (SKU, Nombre, Código barras, Cat.)" style="min-width:260px">
          <div class="ms-auto d-flex gap-2">
            <button id="btnNueva" class="btn btn-primary btn-sm">
              <i class="fa-solid fa-plus"></i> Nuevo
            </button>
          </div>
        </div>

        <div id="tableWrap" class="flex-fill d-flex flex-column">
          <div class="flex-fill overflow-hidden">
            <table id="tabla" class="table table-striped table-hover w-100 m-0">
              <thead>
                <tr>
                  <th class="mono">SKU</th>
                  <th>Nombre</th>
                  <th>Categoría</th>
                  <th class="dt-center" style="width:110px">U. Medida</th>
                  <th class="dt-center" style="width:100px">Stock Min</th>
                  <th class="dt-center" style="width:100px">Stock Max</th>
                  <th class="dt-center" style="width:80px">Activo</th>
                  <th class="dt-center" style="width:110px">Estado</th>
                  <th class="dt-center" style="width:220px">Acciones</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </section>
    </main>
  </div>
</div>

<!-- Modal CRUD -->
<div class="modal fade" id="modalForm" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form class="modal-content" id="formAcc">
      <div class="modal-header py-2">
        <h6 class="modal-title"><span id="ttlForm">Nuevo Accesorio</span></h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="id_accesorio" name="id_accesorio" value="0">
        <div class="row g-2">
          <div class="col-md-4">
            <label class="form-label">SKU *</label>
            <input type="text" class="form-control mono" id="sku" name="sku" maxlength="64" required>
          </div>
          <div class="col-md-8">
            <label class="form-label">Nombre *</label>
            <input type="text" class="form-control" id="nombre" name="nombre" maxlength="150" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Categoría *</label>
            <select class="form-select" id="id_categoria" name="id_categoria" required></select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Unidad Medida</label>
            <input class="form-control" id="unidad_medida" name="unidad_medida" placeholder="p.ej. UN, PAR, JGO">
          </div>
          <div class="col-md-3">
            <label class="form-label">Código barras</label>
            <input class="form-control mono" id="codigo_barras" name="codigo_barras" maxlength="64">
          </div>
          <div class="col-12">
            <label class="form-label">Descripción</label>
            <textarea class="form-control" id="descripcion" name="descripcion" rows="2"></textarea>
          </div>
          <div class="col-md-6">
            <label class="form-label">Attrs (JSON)</label>
            <textarea class="form-control mono" id="attrs" name="attrs" rows="2" placeholder='{"color":"negro","material":"ABS"}'></textarea>
          </div>
          <div class="col-md-3">
            <label class="form-label">Stock Min *</label>
            <input type="number" class="form-control" id="stock_min" name="stock_min" min="0" step="1" value="0" required>
          </div>
          <div class="col-md-3">
            <label class="form-label">Stock Max *</label>
            <input type="number" class="form-control" id="stock_max" name="stock_max" min="0" step="1" value="0" required>
          </div>
          <div class="col-md-6">
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" id="activo" name="activo" checked>
              <label class="form-check-label" for="activo">Activo (operativo)</label>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" id="condicion" name="condicion" checked>
              <label class="form-check-label" for="condicion">Habilitado</label>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer py-2">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
        <button type="submit" class="btn btn-primary btn-sm">Guardar</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
const apiBase = (window.SGO_API_BASE ?? 'api/');
let dt=null, modal, form;

document.addEventListener('DOMContentLoaded', () => {
  modal = new bootstrap.Modal(document.getElementById('modalForm'));
  form  = document.getElementById('formAcc');

  cargarCategoriasFiltro();
  initTable();
  window.addEventListener('resize', debounce(resizeTableHeight, 150));

  document.getElementById('txtBuscar').addEventListener('input', recargarTabla);
  document.getElementById('fCategoria').addEventListener('change', recargarTabla);
  document.getElementById('fEstado').addEventListener('change', recargarTabla);
  document.getElementById('btnNueva').addEventListener('click', nueva);
  form.addEventListener('submit', onGuardar);
});

/* ===== combos ===== */
function cargarCategoriasFiltro(){
  fetch(`${apiBase}categoria_options.php`)
    .then(r=>r.json()).then(j=>{
      const sel = document.getElementById('fCategoria');
      (j.data||[]).forEach(o=>{
        const opt=document.createElement('option');
        opt.value=o.id_categoria; opt.textContent=o.nombre; sel.appendChild(opt);
      });
    });
}
function cargarCategoriasModal(selected=0){
  fetch(`${apiBase}categoria_options.php`)
    .then(r=>r.json()).then(j=>{
      const sel = document.getElementById('id_categoria');
      sel.innerHTML='';
      (j.data||[]).forEach(o=>{
        const opt=document.createElement('option');
        opt.value=o.id_categoria; opt.textContent=o.nombre; sel.appendChild(opt);
      });
      if (selected) sel.value = String(selected);
    });
}

/* ===== DataTable ===== */
function initTable(){
  if (dt) return;
  const h = computeScrollY();
  dt = new DataTable('#tabla', {
    data: [],
    columns: [
      { data: 'sku', className:'mono' },
      { data: 'nombre' },
      { data: 'categoria' },
      { data: 'unidad_medida', className:'dt-center' },
      { data: 'stock_min', className:'dt-center' },
      { data: 'stock_max', className:'dt-center' },
      { data: 'activo', className:'dt-center', render:v=> v==1? '<span class="badge bg-info">Sí</span>':'<span class="badge bg-secondary">No</span>' },
      { data: 'condicion', className:'dt-center', render:v=> v==1? '<span class="badge bg-success">Habilitado</span>':'<span class="badge bg-dark">Inactivo</span>' },
      { data: null, className:'dt-center', orderable:false, render: row => accionesHTML(row) },
    ],
    order: [[2,'asc'], [1,'asc']],
    scrollY: h + 'px',
    scrollCollapse: true,
    paging: true,
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });
  recargarTabla();
}

function recargarTabla(){
  const q   = encodeURIComponent(document.getElementById('txtBuscar').value || '');
  const cat = encodeURIComponent(document.getElementById('fCategoria').value || '');
  const est = encodeURIComponent(document.getElementById('fEstado').value || '0');
  fetch(`${apiBase}accesorio_list.php?_=${Date.now()}&search=${q}&id_categoria=${cat}&soloActivos=${est}`)
    .then(r=>r.json())
    .then(j=>{
      if(!j.success) throw new Error(j.message||'Error');
      const pagina = dt.page();
      dt.clear();
      dt.rows.add(j.data || []);
      dt.draw(false);
      dt.page(pagina).draw(false);
      resizeTableHeight();
    })
    .catch(err=>{
      console.error(err);
      Swal.fire('Error','No se pudo cargar la lista','error');
    });
}

function resizeTableHeight(){
  if (!dt) return;
  const h = computeScrollY();
  const wrapper = document.querySelector('#tabla')?.closest('.dataTables_wrapper');
  const scroller = wrapper?.querySelector('.dataTables_scrollBody');
  if (scroller) {
    scroller.style.height = h + 'px';
    scroller.style.maxHeight = h + 'px';
  }
  dt.columns.adjust();
}
function computeScrollY(){
  const tableWrap = document.getElementById('tableWrap');
  const wrapper   = document.querySelector('#tabla')?.closest('.dataTables_wrapper');
  const headH = wrapper?.querySelector('.dataTables_scrollHead')?.offsetHeight || 0;
  const infoH = wrapper?.querySelector('.dataTables_info')?.offsetHeight || 0;
  const pagH  = wrapper?.querySelector('.dataTables_paginate')?.offsetHeight || 0;
  const gap   = 16;
  const wrapH = tableWrap?.clientHeight || 400;
  return Math.max(160, wrapH - headH - infoH - pagH - gap);
}

/* ===== UI acciones ===== */
function nueva(){
  form.reset();
  document.getElementById('id_accesorio').value = 0;
  document.getElementById('activo').checked = true;
  document.getElementById('condicion').checked = true;
  document.getElementById('ttlForm').textContent = 'Nuevo Accesorio';
  cargarCategoriasModal();
  modal.show();
}
function accionesHTML(row){
  const id = row.id_accesorio;
  return `
    <button class="btn btn-sm btn-outline-primary me-1" onclick="editar(${id})" title="Editar"><i class="fa-solid fa-pen"></i></button>
    <button class="btn btn-sm btn-outline-warning me-1" onclick="toggleEstado(${id})" title="Habilitar/Inhabilitar"><i class="fa-solid fa-power-off"></i></button>
    <button class="btn btn-sm btn-outline-danger" onclick="eliminar(${id})" title="Eliminar/Inactivar"><i class="fa-solid fa-trash"></i></button>
  `;
}
function editar(id){
  fetch(`${apiBase}accesorio_get.php?id=${id}`)
    .then(r=>r.json())
    .then(j=>{
      if(!j.success) return Swal.fire('Atención', j.message||'No encontrado', 'warning');
      const d = j.data;
      document.getElementById('id_accesorio').value = d.id_accesorio;
      document.getElementById('sku').value = d.sku;
      document.getElementById('nombre').value = d.nombre;
      document.getElementById('descripcion').value = d.descripcion ?? '';
      document.getElementById('unidad_medida').value = d.unidad_medida ?? '';
      document.getElementById('codigo_barras').value = d.codigo_barras ?? '';
      document.getElementById('attrs').value = d.attrs ?? '';
      document.getElementById('stock_min').value = d.stock_min ?? 0;
      document.getElementById('stock_max').value = d.stock_max ?? 0;
      document.getElementById('activo').checked = (parseInt(d.activo)===1);
      document.getElementById('condicion').checked = (parseInt(d.condicion)===1);
      document.getElementById('ttlForm').textContent = 'Editar Accesorio';
      cargarCategoriasModal(d.id_categoria);
      modal.show();
    })
    .catch(()=> Swal.fire('Error','No se pudo obtener el registro','error'));
}
function onGuardar(e){
  e.preventDefault();
  const payload = {
    id_accesorio: parseInt(document.getElementById('id_accesorio').value || '0'),
    sku: (document.getElementById('sku').value || '').trim(),
    nombre: (document.getElementById('nombre').value || '').trim(),
    id_categoria: parseInt(document.getElementById('id_categoria').value || '0'),
    descripcion: document.getElementById('descripcion').value || '',
    unidad_medida: document.getElementById('unidad_medida').value || '',
    codigo_barras: document.getElementById('codigo_barras').value || '',
    attrs: document.getElementById('attrs').value || '',
    stock_min: parseInt(document.getElementById('stock_min').value || '0'),
    stock_max: parseInt(document.getElementById('stock_max').value || '0'),
    activo: document.getElementById('activo').checked ? 1 : 0,
    condicion: document.getElementById('condicion').checked ? 1 : 0
  };
  if (!payload.sku || !payload.nombre || !payload.id_categoria) {
    return Swal.fire('Validación','SKU, Nombre y Categoría son obligatorios','info');
  }
  if (payload.stock_min<0 || payload.stock_max<0 || payload.stock_min>payload.stock_max){
    return Swal.fire('Validación','Revisa los rangos de stock','info');
  }
  // Validar JSON si viene texto en attrs
  if (payload.attrs){
    try { JSON.parse(payload.attrs); } catch (e) {
      return Swal.fire('Validación','"Attrs" debe ser un JSON válido','info');
    }
  }

  fetch(`${apiBase}accesorio_save.php`, {
    method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload)
  })
  .then(r=>r.json())
  .then(j=>{
    if(!j.success) return Swal.fire('Atención', j.message||'No se pudo guardar', 'warning');
    Swal.fire('Éxito', j.message||'Guardado', 'success');
    modal.hide();
    recargarTabla();
  })
  .catch(()=> Swal.fire('Error','No se pudo guardar','error'));
}
function toggleEstado(id){
  fetch(`${apiBase}accesorio_toggle.php`, {
    method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({id_accesorio:id})
  })
  .then(r=>r.json())
  .then(j=>{
    if(!j.success) return Swal.fire('Atención', j.message||'No se pudo actualizar', 'warning');
    recargarTabla();
  })
  .catch(()=> Swal.fire('Error','No se pudo actualizar','error'));
}
function eliminar(id){
  Swal.fire({
    title: '¿Eliminar?', text: 'Puedes inactivarlo en lugar de eliminar.',
    icon:'warning', showCancelButton:true, confirmButtonText:'Eliminar', cancelButtonText:'Cancelar'
  }).then(res=>{
    if(!res.isConfirmed) return;
    fetch(`${apiBase}accesorio_delete.php`, {
      method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({id_accesorio:id, hard:0})
    })
    .then(r=>r.json())
    .then(j=>{
      if(!j.success) return Swal.fire('Atención', j.message||'No se pudo eliminar', 'warning');
      Swal.fire('Listo', j.message||'Eliminado', 'success');
      recargarTabla();
    })
    .catch(()=> Swal.fire('Error','No se pudo eliminar','error'));
  });
}

/* Utils */
function debounce(fn, wait=200){ let t; return (...a)=>{ clearTimeout(t); t=setTimeout(()=>fn.apply(this,a), wait); }; }
</script>
</body>
</html>
