<?php 
// solicitud_previa.php — SGO · Solicitud Previa (BS5 + DataTables + Import .xlsx)
// Requisitos: api/solicitud_list.php, api/localidad_list.php, api/categoria_list.php,
//             api/bodega_list.php, api/monedas_list.php, api/buscar_localidad.php,
//             api/buscar_ruc.php, importar/import.php, api/solicitud_detalle.php,
//             api/solicitud_get.php, api/solicitud_update.php, api/datadai_update.php,
//             api/datadai_delete.php, api/solicitud_delete.php, qr/imprimir_multiple.php
declare(strict_types=1);
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') { header("Location: ../../views/index.php"); exit(); }
$usuario = $_SESSION['usuario'] ?? '';
$permiso = (int)($_SESSION['permiso'] ?? 0);

/* Conexión */
$pathConex = realpath(__DIR__ . '/conex.php') ?: realpath(__DIR__ . '/../../conex.php');
if (!$pathConex) { die('No se encontró conex.php'); }
require_once $pathConex;
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>SGO · Solicitud Previa</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>
<link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet"/>

<style>
  body{background:#f7f9fc}
  .tabla-preview{font-size:12px}
  .tabla-preview th,.tabla-preview td{white-space:nowrap;padding:4px 8px;vertical-align:middle}
  .dt-nowrap{white-space:nowrap}
  .btn-icon{border:0;background:transparent;padding:0;line-height:1}
  .table-sm th, .table-sm td{vertical-align:middle}
</style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <?php include __DIR__ . '/partials/menu.php'; ?>
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <?php include __DIR__ . '/partials/topbar.php'; ?>

      <div class="row px-3 py-2">
        <div class="col-12 d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Solicitudes Previas</h5>
          <button type="button" class="btn btn-success" id="btnAbrirSP" data-bs-toggle="modal" data-bs-target="#agregar_solicitudp">
            <i class="fa fa-plus"></i> Agregar Solicitud Previa
          </button>
        </div>
      </div>

      <div class="row px-3 pb-3">
        <div class="col-12">
          <div class="table-responsive">
            <table id="solicitud" class="table table-hover table-sm align-middle w-100">
              <thead>
                <tr class="table-info">
                  <th class="dt-nowrap">S.P.</th>
                  <th class="dt-nowrap">DAI 70</th>
                  <th class="dt-nowrap">PEDIDO</th>
                  <th class="dt-nowrap">TRIBUTO</th>
                  <th class="dt-nowrap">CÓDIGO EMBARQUE</th>
                  <th class="dt-nowrap">RUC</th>
                  <th>IMPORTADOR/CONSIGNATARIO</th>
                  <th class="dt-nowrap">CATEGORÍA</th>
                  <th style="width:140px;" class="text-center">Acciones</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
          <small class="text-muted d-block px-1">Consejo: use el buscador para filtrar por SP, RUC, categoría, naviera, etc.</small>
        </div>
      </div>
    </main>
  </div>
</div>

<!-- Modal Agregar / Editar (alta + import) -->
<div class="modal fade" id="agregar_solicitudp" tabindex="-1" aria-labelledby="agregarSolicitudLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen modal-dialog-centered">
    <div class="modal-content">
      <form id="formSolicitud" autocomplete="off" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title" id="agregarSolicitudLabel"><i class="fa-solid fa-file-circle-plus me-2"></i> Agregar nueva solicitud</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>

        <div class="modal-body">
          <input type="hidden" name="id" id="sol_id" value="0">
          <input type="hidden" name="idempresa" id="idempresa" value="">
          <div class="row g-0">
            <div class="col-lg-12">
              <div class="card h-100 border-primary mb-0">
                <div class="card-header bg-primary text-white"><i class="fa-solid fa-file-contract me-2"></i> SOLICITUD PREVIA A DEPÓSITO ADUANERO PÚBLICO</div>
                <div class="card-body">
                  <div class="row g-2">
                    <div class="col-2">
                      <select class="form-select" id="localidad" name="id_localidad" required>
                        <option value="">LOCALIDAD*</option>
                      </select>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="codigo" name="codigo" placeholder="CÓDIGO*" required>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="anio" name="anio" value="<?php echo date('Y');?>" placeholder="AÑO*" required>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="numero" name="numero" placeholder="NÚMERO*" required>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="embarque" name="codigo_embarque" placeholder="EMBARQUE*" required>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="pedido" name="pedido" placeholder="PEDIDO*" required>
                    </div>
                    <div class="col-1">
                      <input class="form-control" id="tributo" name="tributo" placeholder="TRIBUTO*" required>
                    </div>
                    <div class="col-4">
                      <input class="form-control" id="naviera" name="naviera" placeholder="NAVIERA">
                    </div>
                    <div class="col-2">
                      <input class="form-control" id="ruc" name="ruc" placeholder="RUC*" required>
                    </div>
                    <div class="col-4">
                      <input class="form-control" id="razon" name="razon" placeholder="RAZÓN SOCIAL*" required>
                    </div>
                    <div class="col-2">
                      <input class="form-control" type="date" id="fecha_emision" name="fecha_emision" required>
                    </div>
                    <div class="col-2">
                      <select class="form-select" id="categoria" name="id_categoria" required>
                        <option value="">--Seleccione categoria--</option>
                      </select>
                    </div>
                    <div class="col-2">                   
                      <select class="form-select" id="idmoneda" name="idmoneda" required>
                        <option value="">--Seleccione moneda--</option>
                      </select>
                    </div>
                    <div class="col-3">
                      <input class="form-control" id="daie" name="daie" placeholder="NÚMERO DE DAI*" required>
                    </div>
                    <div class="col-3">
                      <select class="form-select" id="bodega" name="bodega" required>
                        <option value="">BODEGA LK*</option>
                      </select>
                    </div>
                    <div class="col-3">
                      <input class="form-control" type="date" id="fechae" name="fechae" placeholder="FECHA INICIO R.70*" required>
                    </div>
                    <div class="col-3">
                      <input class="form-control" type="date" id="fechaev" name="fechaev" placeholder="FECHA VENC. R.70*" required>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Card de carga de archivo -->
            <div class="row mt-3 g-0">
              <div class="col-12">
                <div class="card border-info mb-0">
                  <div class="card-header bg-info text-white"><i class="fa-solid fa-file-import me-2"></i> IMPORTAR ARCHIVO</div>
                  <div class="card-body">
                    <div class="row g-2 align-items-center">
                      <div class="col-lg-9 col-md-8">
                        <input type="file" class="form-control" name="archivo" id="archivo" accept=".xlsx,.xls" required>
                      </div>
                      <div class="col-lg-3 col-md-4">
                        <div class="d-flex gap-2">
                          <button type="submit" class="btn btn-info text-white flex-fill" id="btnImportar" disabled>
                            <i class="fa-solid fa-upload me-1"></i> Importar y Guardar
                          </button>
                          <button type="button" class="btn btn-light flex-fill" data-bs-dismiss="modal">
                            <i class="fa-solid fa-xmark me-1"></i> Cerrar
                          </button>
                        </div>
                      </div>
                    </div>

                    <div class="mt-3">
                      <div class="table-responsive" style="max-height:300px;overflow:auto;">
                        <table class="table table-bordered table-sm tabla-preview" id="previewTable">
                          <thead class="table-light"></thead>
                          <tbody></tbody>
                        </table>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>

          </div><!-- /.row g-0 -->
        </div><!-- /.modal-body -->

        <div class="modal-footer">
          <small class="text-muted">El botón <b>Importar y Guardar</b> enviará la solicitud y el archivo Excel.</small>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal: Detalle de Solicitud -->
<div class="modal fade" id="modalDetalleSP" tabindex="-1" aria-labelledby="modalDetalleLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalDetalleLabel">Detalle de S.P. <span id="detSP"></span></h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <div class="modal-body">
        <div class="d-flex flex-wrap align-items-center gap-2 mb-2">
          <button type="button" class="btn btn-outline-primary btn-sm" id="btnSelectFiltered">
            <i class="fa fa-check-double me-1"></i> Seleccionar filtrados
          </button>
          <button type="button" class="btn btn-outline-secondary btn-sm" id="btnUnselectFiltered">
            <i class="fa fa-square me-1"></i> Desmarcar filtrados
          </button>
          <button type="button" class="btn btn-outline-dark btn-sm" id="btnClearAll" disabled>
            <i class="fa fa-ban me-1"></i> Limpiar selección
          </button>
          <button type="button" class="btn btn-success btn-sm ms-auto" id="btnPrintQR" disabled>
            <i class="fa fa-print me-1"></i> Imprimir QR
            <span class="badge text-bg-dark ms-1" id="selDetalleCount">0</span>
          </button>
        </div>

        <div class="table-responsive">
          <table id="detalleSolicitud" class="table table-striped table-bordered table-sm w-100">
            <thead class="table-light">
              <tr>
                <th class="text-center" style="width:54px">
                  <div class="d-flex justify-content-center align-items-center">
                    <input type="checkbox" class="form-check-input js-checkall-detalle" title="Seleccionar/Desmarcar todos"/>
                    <button type="button" class="btn-icon ms-1 js-checkall-trigger" title="Seleccionar/Desmarcar todos">
                      <i class="fa fa-qrcode"></i>
                    </button>
                  </div>
                </th>
                <th>Item</th>
                <th>Marca</th>
                <th>Modelo</th>
                <th>Chasis</th>
                <th>Motor</th>
                <th>Color</th>
                <th>FOB Unit.</th>
                <th>Transporte</th>
                <th>Seguro</th>
                <th>Valor Aduana</th>
                <th>Estado</th>
                <th>Acción</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Editar Unidad -->
<div class="modal fade" id="modalEditUnidad" tabindex="-1" aria-labelledby="modalEditUnidadLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditUnidad" class="modal-content" autocomplete="off">
      <div class="modal-header bg-warning">
        <h5 class="modal-title" id="modalEditUnidadLabel">Editar Unidad</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="edit_id">
        <div class="mb-2"><label class="form-label">Item</label><input type="text" class="form-control" name="item" id="edit_item"></div>
        <div class="mb-2"><label class="form-label">Marca</label><input type="text" class="form-control" name="marca" id="edit_marca"></div>
        <div class="mb-2"><label class="form-label">Modelo</label><input type="text" class="form-control" name="modelo" id="edit_modelo"></div>
        <div class="mb-2"><label class="form-label">Chasis</label><input type="text" class="form-control" name="chasis" id="edit_chasis" required></div>
        <div class="mb-2"><label class="form-label">Motor</label><input type="text" class="form-control" name="motor" id="edit_motor"></div>
        <div class="mb-2"><label class="form-label">Color</label><input type="text" class="form-control" name="color" id="edit_color"></div>
        <hr class="my-2">
        <div class="row g-2">
          <div class="col-6"><label class="form-label">FOB Unitario</label><input type="number" step="0.01" inputmode="decimal" class="form-control" name="fobunitario" id="edit_fobunitario"></div>
          <div class="col-6"><label class="form-label">Transporte</label><input type="number" step="0.01" inputmode="decimal" class="form-control" name="transporte" id="edit_transporte"></div>
          <div class="col-6"><label class="form-label">Seguro</label><input type="number" step="0.01" inputmode="decimal" class="form-control" name="seguro" id="edit_seguro"></div>
          <div class="col-6"><label class="form-label">Valor Aduana</label><input type="number" step="0.01" inputmode="decimal" class="form-control" name="valoraduana" id="edit_valoraduana"></div>
        </div>
        <hr class="my-2">
        <div class="mb-2"><label class="form-label">Estado (sólo lectura)</label><input type="text" class="form-control" id="edit_estado_text" disabled></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
        <button class="btn btn-warning" type="submit">Guardar cambios</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal: Editar SP -->
<div class="modal fade" id="modalEditSP" tabindex="-1" aria-labelledby="modalEditSPLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <form id="formEditSP" class="modal-content" autocomplete="off">
      <div class="modal-header bg-warning">
        <h5 class="modal-title" id="modalEditSPLabel">Editar Solicitud Previa / DAI</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="editsp_id">
        <input type="hidden" name="idempresa" id="editsp_idempresa">
        <div class="row g-2">
          <div class="col-3"><label class="form-label">Localidad</label><select class="form-select" name="id_localidad" id="editsp_localidad" required><option value="">Cargando…</option></select></div>
          <div class="col-2"><label class="form-label">Código</label><input class="form-control" name="codigo" id="editsp_codigo" required></div>
          <div class="col-2"><label class="form-label">Año</label><input class="form-control" name="anio" id="editsp_anio" required></div>
          <div class="col-2"><label class="form-label">Número</label><input class="form-control" name="numero" id="editsp_numero" required></div>
          <div class="col-3"><label class="form-label">Código Embarque</label><input class="form-control" name="codigo_embarque" id="editsp_embarque" required></div>
          <!-- NUEVOS CAMPOS EN EL MODAL EDITAR -->
          <div class="col-3">
            <label class="form-label">Pedido</label>
            <input class="form-control" name="pedido" id="editsp_pedido" placeholder="Pedido">
          </div>

          <div class="col-9">
            <label class="form-label">Naviera</label>
            <input class="form-control" name="naviera" id="editsp_naviera" placeholder="Naviera">
          </div>
          <div class="col-3"><label class="form-label">Fecha Emisión</label><input type="date" class="form-control" name="fecha_emision" id="editsp_fecha_emision" required></div>
          <div class="col-3"><label class="form-label">Categoría</label><select class="form-select" name="id_categoria" id="editsp_categoria" required><option value="">Cargando…</option></select></div>
          <div class="col-3"><label class="form-label">RUC (solo lectura)</label><input class="form-control" id="editsp_ruc" disabled></div>
          <div class="col-3"><label class="form-label">Razón Social (solo lectura)</label><input class="form-control" id="editsp_razon" disabled></div>
        </div>
        <hr class="my-2">
        <div class="row g-2">
          <div class="col-3"><label class="form-label">DAI Nº</label><input class="form-control" name="daie" id="editsp_dai" required></div>
          <div class="col-3"><label class="form-label">Fecha Inicio R.70</label><input type="date" class="form-control" name="fechae" id="editsp_fechae" required></div>
          <div class="col-3"><label class="form-label">Fecha Venc. R.70</label><input type="date" class="form-control" name="fechaev" id="editsp_fechaev" required></div>
          <div class="col-3"><label class="form-label">Bodega LK</label><select class="form-select" name="bodega" id="editsp_bodega" required><option value="">Cargando…</option></select></div>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancelar</button>
        <button class="btn btn-warning" type="submit">Guardar cambios</button>
      </div>
    </form>
  </div>
</div>

<!-- ====== Librerías ====== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js"></script>

<script>
// ======================= Endpoints =======================
const API_LIST='api/solicitud_list.php';

// ======================= Estado =======================
let tabla, modalSP;

// UI helpers
const showInfo=(m)=>{window.Swal?Swal.fire('Aviso',m,'info'):alert(m)};
const showErr =(m)=>{window.Swal?Swal.fire('Error',m,'error'):alert('Error: '+m)};

// Selects genéricos
function cargarSelect(url,$select,valueKey,textKey){
  $.getJSON(url,function(resp){
    $select.empty().append('<option value="">-- Seleccione --</option>');
    if(Array.isArray(resp?.data)){resp.data.forEach(it=>$select.append($('<option>',{value:it[valueKey]}).text(it[textKey])))}
  });
}
function cargarSelectBodega(){
  $.getJSON('api/bodega_list.php',function(res){
    const $sel=$('#bodega'); $sel.empty().append('<option value="">Seleccione Bodega*</option>');
    if(res?.success && Array.isArray(res.data)){res.data.forEach(it=>$sel.append(`<option value="${it.id}">${it.nombre}</option>`))}
  });
}

// --- Monedas: usa el formato {data:[{idmoneda,detalle,siglas,text}]}
async function cargarMonedasSolicitud(){
  try{
    const sel = document.getElementById('idmoneda');
    if (!sel) return;
    sel.innerHTML = '<option value="">--Seleccione moneda--</option>';
    const res  = await fetch('api/monedas_list.php', { cache:'no-store' });
    const json = await res.json();
    const arr  = Array.isArray(json?.data) ? json.data : [];
    arr.forEach(m=>{
      const id   = m.idmoneda;
      const text = m.text || [m.detalle, m.siglas ? `(${m.siglas})` : ''].filter(Boolean).join(' ');
      if (!id) return;
      const opt = document.createElement('option');
      opt.value = String(id);
      opt.textContent = text || `Moneda ${id}`;
      sel.appendChild(opt);
    });
  }catch(e){ console.error('monedas_list error:', e); }
}

const limpiarForm=()=>{
  $('#sol_id').val(0);$('#idempresa').val('');
  $('#localidad').val('');$('#codigo').val('');$('#anio').val('<?php echo date('Y');?>');$('#numero').val('');
  $('#embarque').val('');$('#pedido').val('');$('#tributo').val('');
  $('#naviera').val('');$('#ruc').val('');$('#razon').val('');
  $('#fecha_emision').val('');$('#categoria').val('');
  $('#idmoneda').val(''); // limpiar moneda
  $('#daie').val('');$('#bodega').val('');$('#fechae').val('');$('#fechaev').val('');
  const $a=document.getElementById('archivo'); if($a)$a.value='';
  renderPreview([]); toggleBtnImport();
};

// Stubs seguros
function renderPreview(data){
  const t=document.getElementById('previewTable'); if(!t) return;
  const thead=t.querySelector('thead'), tbody=t.querySelector('tbody');
  thead.innerHTML=''; tbody.innerHTML='';
  if(!Array.isArray(data)||!data.length){tbody.innerHTML='<tr><td colspan="10" class="text-center text-muted">Sin datos</td></tr>';return;}
  const hr=document.createElement('tr'); (data[0]||[]).forEach(col=>{const th=document.createElement('th');th.textContent=(col??'');hr.appendChild(th);}); thead.appendChild(hr);
  data.slice(1,21).forEach(row=>{const tr=document.createElement('tr'); (row||[]).forEach(cell=>{const td=document.createElement('td'); td.textContent=(cell!=null)?cell:''; tr.appendChild(td);}); tbody.appendChild(tr);});
}
function toggleBtnImport(){}
</script>

<script>
// ======================= Listado principal =======================
$(function(){
  modalSP=new bootstrap.Modal(document.getElementById('agregar_solicitudp'),{backdrop:'static',keyboard:false});
  cargarSelect('api/localidad_list.php',$('#localidad'),'id','nombre');
  cargarSelect('api/categoria_list.php',$('#categoria'),'id','detalle');

  // DataTable principal (con columna Acciones construida en cliente)
  tabla = $('#solicitud').DataTable({
    processing:true,
    ajax:{url:API_LIST,type:'GET',dataSrc:(j)=>(j&&j.success&&Array.isArray(j.data))?j.data:[]},
    columns:[
      {data:'numerosp',defaultContent:''},                               // S.P.
      {data:null,defaultContent:'',render:(r)=>r?.numerodai??r?.dai??''}, // DAI 70
      {data:'pedido',defaultContent:''},
      {data:'tributo',defaultContent:''},
      {data:'embarque',defaultContent:''},
      {data:'ruc',defaultContent:''},
      {data:null,defaultContent:'',render:(r)=>r?.razon_social??r?.razon??''},
      {data:'categoria',defaultContent:''},
      {
        data:null, orderable:false, searchable:false, className:'text-center',
        render:(row)=>{
          const id = row?.idsolicitudprevia ?? row?.id ?? 0;
          const sp = row?.numerosp ?? '';
          return `
            <div class="btn-group btn-group-sm" role="group">
              <button class="btn btn-outline-primary btn-ver" data-id="${id}" data-sp="${sp}" title="Ver detalle">
                <i class="fa fa-eye"></i>
              </button>
              <button class="btn btn-outline-warning btn-editar-sp" data-id="${id}" title="Editar SP/DAI">
                <i class="fa fa-pen"></i>
              </button>
              <button class="btn btn-outline-danger btn-eliminar-sp" data-id="${id}" data-sp="${sp}" title="Eliminar">
                <i class="fa fa-trash"></i>
              </button>
            </div>`;
        }
      }
    ],
    order:[[0,'desc']],
    language:{
      processing:"Procesando...",search:"Buscar:",lengthMenu:"Mostrar _MENU_",
      info:"_START_–_END_ de _TOTAL_",infoEmpty:"0–0 de 0",infoFiltered:"(filtrado de _MAX_)",
      loadingRecords:"Cargando...",zeroRecords:"No hay registros",emptyTable:"Sin datos",
      paginate:{first:"Primero",previous:"Anterior",next:"Siguiente",last:"Último"}
    }
  });

  // Abrir modal: limpiar, cargar bodega y moneda
  $('#btnAbrirSP').on('click',()=>{limpiarForm();$('#agregarSolicitudLabel').text('Agregar nueva solicitud');modalSP.show();});
  $('#agregar_solicitudp').on('shown.bs.modal', async ()=>{
    cargarSelectBodega();
    await cargarMonedasSolicitud();
    if (typeof toggleBtnImport === 'function') toggleBtnImport();
  });

  // Autocódigo por localidad
  $('#localidad').on('change',function(){
    const localidad=$(this).val();
    if(!localidad){$('#codigo').val('');toggleBtnImport();return;}
    $.ajax({url:'api/buscar_localidad.php',type:'POST',dataType:'json',data:{localidad}})
      .done(r=>{ if(r?.success){$('#codigo').val(r.codigo||'');} else {$('#codigo').val('');} })
      .fail(()=>{ $('#codigo').val(''); })
      .always(()=>toggleBtnImport());
  });

  // RUC lookup
  $('#ruc').on('change',function(){
    let ruc=String($(this).val()||'').trim().replace(/\D+/g,'');
    if(ruc && ruc.length!==13){$('#idempresa').val('');$('#razon').val('');$('#ruc').val('');toggleBtnImport();return;}
    if(!ruc){$('#idempresa').val('');$('#razon').val('');toggleBtnImport();return;}
    $.ajax({url:'api/buscar_ruc.php',type:'POST',dataType:'json',data:{ruc}})
      .done(res=>{ if(res?.success){$('#idempresa').val(res.idempresa||'');$('#razon').val(res.razon_social||'');$('#ruc').val(res.ruc||ruc);} else {$('#idempresa').val('');} })
      .always(()=>toggleBtnImport());
  });

  // Preview de .xlsx/.xls
  const $archivo=document.getElementById('archivo');
  const $btnImport=document.getElementById('btnImportar');
  const extOk=f=>{const e=f?(f.name.split('.').pop()||'').toLowerCase():'';return e==='xlsx'||e==='xls';};
  $archivo.addEventListener('change',ev=>{
    const file=ev.target.files?.[0]; $btnImport.disabled=!(file&&extOk(file));
    if(!file){renderPreview([]);toggleBtnImport();return;}
    if(!extOk(file)){ $btnImport.disabled=true; ev.target.value=''; renderPreview([]); toggleBtnImport(); return; }
    const reader=new FileReader();
    reader.onload=e=>{
      try{ const wb=XLSX.read(new Uint8Array(e.target.result),{type:'array'}); const ws=wb.Sheets[wb.SheetNames[0]]; renderPreview(XLSX.utils.sheet_to_json(ws,{header:1})); }
      catch{ /* noop */ }
    };
    reader.readAsArrayBuffer(file);
    toggleBtnImport();
  });

  // Activación del botón Importar (exige Moneda)
  const getVal=id=>(document.getElementById(id)?.value||'').trim();
  window.toggleBtnImport=function(){
    const req=[
      'localidad','codigo','anio','numero','embarque',
      'pedido','tributo',
      'ruc','razon','fecha_emision','categoria',
      'idmoneda', // exige moneda
      'daie','bodega','fechae','fechaev'
    ];
    const ok=req.every(id=>getVal(id)!=='');
    const f=$archivo.files?.[0];
    $btnImport.disabled=!(ok && f && extOk(f));
  };
  ['localidad','codigo','anio','numero','embarque','pedido','tributo','naviera','ruc','razon','fecha_emision','categoria','idmoneda','daie','bodega','fechae','fechaev','archivo']
    .forEach(id=>document.getElementById(id)?.addEventListener('input',toggleBtnImport));
  ['localidad','categoria','bodega','idmoneda']
    .forEach(id=>document.getElementById(id)?.addEventListener('change',toggleBtnImport));
  ['codigo','anio','numero'].forEach(id=>document.getElementById(id)?.addEventListener('input',e=>{e.target.value=e.target.value.toUpperCase().trim();toggleBtnImport();}));

  // Submit: importar y guardar
  document.getElementById('formSolicitud').addEventListener('submit',async function(e){
    e.preventDefault();
    const file=$archivo.files?.[0]; if(!file||!extOk(file)) return;
    try{
      Swal.fire({title:'Importando...',html:'Procesando archivo, espera por favor',allowOutsideClick:false,didOpen:()=>Swal.showLoading()});
      $btnImport.disabled=true;
      const sp=`${getVal('codigo')}-${getVal('anio')}-${getVal('numero')}`.toUpperCase();
      const fd=new FormData(this); 
      fd.set('sp',sp); 
      fd.set('localidad',document.getElementById('localidad')?.value||'');
      const resp=await fetch('importar/import.php',{method:'POST',body:fd});
      const raw=await resp.text(); 
      let json=null; try{ json=JSON.parse(raw);}catch{ throw new Error('Respuesta no válida del servidor');}
      if(json?.success===false) throw new Error(json?.message||'Error durante la importación.');
      await Swal.fire({icon:'success',title:'Resumen de importación',html:`<b>Insertados:</b> ${json.insertados??0}<br><b>Duplicados:</b> ${json.duplicados??0}<br><b>Errores:</b> ${json.errores??0}`,width:'30%'});
      $('#solicitud').DataTable().ajax.reload(null,false);
      const modal=bootstrap.Modal.getInstance(document.getElementById('agregar_solicitudp')); if(modal)modal.hide();
      this.reset(); renderPreview([]); $btnImport.disabled=true;
    }catch(err){ console.error(err); showErr('No se pudo completar la importación.'); }
    finally{$btnImport.disabled=false;}
  });
});
</script>

<script>
// ======================= Detalle: selección + impresión por POST =======================
let dtDetalle = null, _idsp_actual = 0;
const esc=(s)=>String(s??'').replace(/&/g,'&amp;').replace(/"/g,'&quot;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
const extractNumeric=(v)=>{const n=parseInt(v,10);return Number.isFinite(n)&&n>0?n:null};
function extractId(row){
  if(!row||typeof row!=='object') return null;
  const pref=['id','iddet','id_detalle','id_dai_detalle','id_dato','id_unidad','detalle_id','id_dai','id_daiitem','id_dai_det','id_det','iddetalle','id_dai_det_dato','id_datadai','id_daidet','id_dai_detalle_id','id_dai_det_id'];
  for(const k of pref){ if(k in row){ const n=extractNumeric(row[k]); if(n) return n; } }
  const blacklist=/(empresa|bodega|categoria|localidad|usuario|cliente|proveedor|ruc|pais|estado|color|marca|modelo)$/i;
  for(const k of Object.keys(row)){ if(!/id/i.test(k)) continue; if(blacklist.test(k)) continue; const n=extractNumeric(row[k]); if(n) return n; }
  return null;
}
function syncHeaderCheckboxDetalle(){
  if (!$.fn.dataTable.isDataTable('#detalleSolicitud')) return;
  const dt=$('#detalleSolicitud').DataTable();
  const rowsIdx=dt.rows({search:'applied'}).indexes();
  let vis=0,chk=0;
  rowsIdx.each(function(i){vis++;const node=dt.row(i).node();const cb=$(node).find('.row-check-detalle').get(0); if(cb&&cb.checked) chk++;});
  const $heads=$(dt.table().container()).find('thead input.js-checkall-detalle');
  $heads.prop({checked: vis>0 && chk===vis, indeterminate: chk>0 && chk<vis});
}
function updateSelUIDetalle(){
  const totalChecked=document.querySelectorAll('#detalleSolicitud .row-check-detalle:checked').length;
  $('#selDetalleCount').text(totalChecked);
  const off=totalChecked===0;
  $('#btnPrintQR').prop('disabled',off);
  $('#btnClearAll').prop('disabled',off);
  syncHeaderCheckboxDetalle();
}
function openDetalle(idsp, sp){
  _idsp_actual = idsp;
  $('#detSP').text(sp||'');
  if (!dtDetalle){
    dtDetalle = $('#detalleSolicitud').DataTable({
      processing:true,
      ajax:{ url:'api/solicitud_detalle.php', type:'GET', data:d=>{d.idsp=_idsp_actual}, dataSrc:j=>(j&&j.success&&Array.isArray(j.data))?j.data:[] },
      columns:[
        { data:null, orderable:false, searchable:false, className:'text-center',
          render:(_,__,row)=>{
            const id=extractId(row);
            const vin=String(row?.chasis ?? row?.vin ?? row?.itemdai ?? '').trim();
            const color=String(row?.color ?? ''); const marca=String(row?.marca ?? ''); const modelo=String(row?.modelo ?? '');
            const tip=(!id||!vin)?'Falta ID o VIN — podría omitirse al imprimir':'Seleccionar';
            return `<div class="form-check d-flex justify-content-center"><input type="checkbox" class="form-check-input row-check-detalle" value="${id? id : ''}" data-chasis="${esc(vin)}" data-color="${esc(color)}" data-marca="${esc(marca)}" data-modelo="${esc(modelo)}" title="${esc(tip)}"></div>`;
          }
        },
        {data:'item',defaultContent:''}, {data:'marca',defaultContent:''}, {data:'modelo',defaultContent:''},
        {data:'chasis',defaultContent:''}, {data:'motor',defaultContent:''}, {data:'color',defaultContent:''},
        {data:'fobunitario',defaultContent:''}, {data:'transporte',defaultContent:''}, {data:'seguro',defaultContent:''},
        {data:'valoraduana',defaultContent:''}, {data:'estado',defaultContent:''},
        {data:'accion',orderable:false,searchable:false,className:'text-center',defaultContent:''}
      ],
      order:[[1,'asc']], paging:false, scrollY:'65vh', scrollCollapse:true,
      language:{processing:"Procesando...",search:"Buscar:",lengthMenu:"Mostrar _MENU_",info:"_START_–_END_ de _TOTAL_",infoEmpty:"0–0 de 0",infoFiltered:"(filtrado de _MAX_)",loadingRecords:"Cargando...",zeroRecords:"Sin registros",emptyTable:"Sin datos",paginate:{first:"Primero",previous:"Anterior",next:"Siguiente",last:"Último"}},
      drawCallback:function(){ syncHeaderCheckboxDetalle(); }
    });
  } else {
    const $heads=$(dtDetalle.table().container()).find('thead input.js-checkall-detalle');
    $heads.prop({checked:false,indeterminate:false});
    dtDetalle.ajax.url('api/solicitud_detalle.php?idsp='+_idsp_actual).load(null,false);
  }
  new bootstrap.Modal(document.getElementById('modalDetalleSP')).show();
}
$('#solicitud').on('click','.btn-ver, a[href^="dai.php"]',function(e){
  e.preventDefault();
  const href=$(this).attr('href')||'';
  const getParam=(u,k)=>{ try { return new URL(u, location.origin).searchParams.get(k); } catch { return null; } };
  let idsp=$(this).data('id') || parseInt(getParam(href,'idsp')||'0',10) || 0;
  let sp=$(this).data('sp') || '';
  if (!sp){
    const tr=$(this).closest('tr');
    const row=$('#solicitud').DataTable().row(tr).data();
    sp = row?.numerosp || '';
  }
  if (!idsp) return;
  $('#selDetalleCount').text('0'); $('#btnPrintQR,#btnClearAll').prop('disabled',true);
  openDetalle(idsp, sp);
});
$(document).on('change','#detalleSolicitud .row-check-detalle',updateSelUIDetalle);
function toggleAllDetalle(checked){
  if (!$.fn.dataTable.isDataTable('#detalleSolicitud')) return;
  const dt=$('#detalleSolicitud').DataTable();
  const rowsIdx=dt.rows({search:'applied'}).indexes();
  rowsIdx.each(function(i){ const node=dt.row(i).node(); $(node).find('.row-check-detalle').prop('checked',!!checked); });
  updateSelUIDetalle();
}
$(document).on('change','thead input.js-checkall-detalle',function(e){ e.stopPropagation(); toggleAllDetalle(this.checked); });
$(document).on('click','thead .js-checkall-trigger',function(e){
  e.preventDefault(); e.stopPropagation();
  const $h=$('thead input.js-checkall-detalle'); const ns=!$h.first().prop('checked');
  $h.prop({checked:ns,indeterminate:false}); toggleAllDetalle(ns);
});
$('#btnSelectFiltered').on('click', ()=> toggleAllDetalle(true));
$('#btnUnselectFiltered').on('click', ()=> toggleAllDetalle(false));
$('#btnClearAll').on('click', ()=> { $('#detalleSolicitud .row-check-detalle').prop('checked', false); updateSelUIDetalle(); });

function buildPayloadSeleccionados(){
  const dt=$.fn.dataTable.isDataTable('#detalleSolicitud')?$('#detalleSolicitud').DataTable():null;
  const checks=document.querySelectorAll('#detalleSolicitud .row-check-detalle:checked');
  const valid=[]; let invalidCount=0;
  checks.forEach(cb=>{
    let id=extractNumeric(cb.value); const vin=(cb.dataset.chasis||'').trim();
    if((!id||id<=0)&&dt){ const $tr=$(cb).closest('tr'); const rowData=dt.row($tr).data()||{}; id=extractId(rowData); }
    if(id&&vin){ valid.push({id, chasis:vin, color:cb.dataset.color||'', marca:cb.dataset.marca||'', modelo:cb.dataset.modelo||''}); }
    else{ invalidCount++; }
  });
  return {valid, invalidCount};
}
function postToImprimirMultiple(payload){
  const form=document.createElement('form'); form.method='POST'; form.target='_blank'; form.action='qr/imprimir_multiple.php';
  const input=document.createElement('input'); input.type='hidden'; input.name='data'; input.value=JSON.stringify(payload);
  form.appendChild(input); document.body.appendChild(form); form.submit(); setTimeout(()=>form.remove(),1500);
}
$('#btnPrintQR').off('click').on('click', function(){
  const {valid, invalidCount}=buildPayloadSeleccionados();
  if (!valid.length && invalidCount>0){ Swal.fire('Aviso','Las unidades seleccionadas carecen de ID o VIN y no se pueden imprimir.','info'); return; }
  if (!valid.length) return;
  const msgExtra=invalidCount?`<br><small class="text-muted">Se omitirán ${invalidCount} unidad(es) sin ID o VIN.</small>`:'';  
  Swal.fire({title:'Imprimir QR',html:`Se imprimirán QR para <b>${valid.length}</b> unidad(es).${msgExtra}`,icon:'question',showCancelButton:true,confirmButtonText:'Sí, imprimir',cancelButtonText:'Cancelar'})
    .then(r=>{ if(r.isConfirmed){ postToImprimirMultiple(valid); toggleAllDetalle(false); } });
});

// ===== Editar SP / Unidad / eliminar =====
async function cargarSelectLocalidadModal(){return $.getJSON('api/localidad_list.php',r=>{const $s=$('#editsp_localidad');$s.empty().append('<option value="">-- Seleccione --</option>');r?.data?.forEach(it=>$s.append(`<option value="${it.id}">${it.nombre}</option>`));});}
async function cargarSelectCategoriaModal(){return $.getJSON('api/categoria_list.php',r=>{const $s=$('#editsp_categoria');$s.empty().append('<option value="">-- Seleccione --</option>');r?.data?.forEach(it=>$s.append(`<option value="${it.id}">${it.detalle}</option>`));});}
async function cargarSelectBodegaModal(){return $.getJSON('api/bodega_list.php',r=>{const $s=$('#editsp_bodega');$s.empty().append('<option value="">-- Seleccione --</option>');r?.data?.forEach(it=>$s.append(`<option value="${it.id}">${it.nombre}</option>`));});}

$('#solicitud').on('click','.btn-editar-sp', async function(){
  const id=$(this).data('id');
  await Promise.all([cargarSelectLocalidadModal(),cargarSelectCategoriaModal(),cargarSelectBodegaModal()]);
  const j=await (await fetch('api/solicitud_get.php?id='+id)).json();
  if(!j?.success){ return Swal.fire('Error', j?.message||'No se pudo cargar', 'error'); }
  const d=j.data;

  $('#editsp_id').val(d.id);
  $('#editsp_idempresa').val(d.id_empresa);
  $('#editsp_localidad').val(d.id_localidad);
  $('#editsp_codigo').val(d.codigo);
  $('#editsp_anio').val(d.anio);
  $('#editsp_numero').val(d.numero);
  $('#editsp_embarque').val(d.codigo_embarque);
  $('#editsp_fecha_emision').val(d.fecha_emision);
  $('#editsp_categoria').val(d.id_categoria);
  $('#editsp_ruc').val(d.ruc);
  $('#editsp_razon').val(d.razon_social);

  // NUEVO
  $('#editsp_pedido').val(d.pedido || '');
  $('#editsp_naviera').val(d.naviera || '');

  $('#editsp_dai').val(d.numerodai ?? d.dai ?? '');
  $('#editsp_fechae').val(d.fechae || '');
  $('#editsp_fechaev').val(d.fechaev || '');
  $('#editsp_bodega').val(String(d.id_bodega || ''));

  new bootstrap.Modal(document.getElementById('modalEditSP')).show();
});


$('#formEditSP').on('submit',async function(e){
  e.preventDefault();
  const fd=new FormData(this);
  const sp=`${$('#editsp_codigo').val()}-${$('#editsp_anio').val()}-${$('#editsp_numero').val()}`.toUpperCase();
  fd.set('sp',sp);
  try{
    const j=await (await fetch('api/solicitud_update.php',{method:'POST',body:fd})).json();
    if(j?.success){
      Swal.fire('Éxito','Actualizado correctamente','success');
      const m=bootstrap.Modal.getInstance(document.getElementById('modalEditSP')); if(m)m.hide();
      $('#solicitud').DataTable().ajax.reload(null,false);
    }else{
      Swal.fire('Error',j?.message||'No se pudo actualizar','error');
    }
  }catch{
    Swal.fire('Error','Fallo de conexión','error');
  }
});

$('#detalleSolicitud').on('click','.btn-edit',function(){
  const b=$(this);
  $('#edit_id').val(b.data('id')); $('#edit_item').val(b.data('item')); $('#edit_marca').val(b.data('marca'));
  $('#edit_modelo').val(b.data('modelo')); $('#edit_chasis').val(b.data('chasis')); $('#edit_motor').val(b.data('motor'));
  $('#edit_color').val(b.data('color')); $('#edit_fobunitario').val(b.data('fobunitario'));
  $('#edit_transporte').val(b.data('transporte')); $('#edit_seguro').val(b.data('seguro')); $('#edit_valoraduana').val(b.data('valoraduana'));
  const estadoText=b.closest('tr').find('td').eq(11).text()||''; $('#edit_estado_text').val(estadoText.trim());
  new bootstrap.Modal(document.getElementById('modalEditUnidad')).show();
});

$('#formEditUnidad').on('submit',function(e){
  e.preventDefault();
  fetch('api/datadai_update.php',{method:'POST',body:new FormData(this)})
    .then(r=>r.json()).then(j=>{
      if(j?.success){
        Swal.fire('Éxito','Actualizado correctamente','success');
        const m=bootstrap.Modal.getInstance(document.getElementById('modalEditUnidad')); if(m)m.hide();
        $('#detalleSolicitud').DataTable().ajax.url('api/solicitud_detalle.php?idsp='+(_idsp_actual||0)).load(null,false);
      }else{Swal.fire('Error',j?.message||'No se pudo actualizar','error');}
    }).catch(()=>Swal.fire('Error','Fallo de conexión','error'));
});

$('#detalleSolicitud').on('click','.btn-del',function(){
  const id=$(this).data('id'); const ch=$(this).data('chasis')||'';
  Swal.fire({title:'¿Eliminar?',html:`¿Eliminar la unidad con chasis <b>${ch}</b>?`,icon:'warning',showCancelButton:true,confirmButtonText:'Sí, eliminar',cancelButtonText:'Cancelar'})
    .then(r=>{
      if(!r.isConfirmed) return;
      const fd=new FormData(); fd.append('id',id);
      fetch('api/datadai_delete.php',{method:'POST',body:fd}).then(r=>r.json()).then(j=>{
        if(j?.success){
          Swal.fire('Éxito','Eliminado correctamente','success');
          $('#detalleSolicitud').DataTable().ajax.url('api/solicitud_detalle.php?idsp='+(_idsp_actual||0)).load(null,false);
        }else{Swal.fire('Error',j?.message||'No se pudo eliminar','error');}
      }).catch(()=>Swal.fire('Error','Fallo de conexión','error'));
    });
});

$('#solicitud').on('click','.btn-eliminar-sp',function(){
  const id=$(this).data('id'); const sp=$(this).data('sp')||'';
  Swal.fire({title:'¿Eliminar S.P.?',html:sp?`Se borrará lógicamente la S.P. <b>${sp}</b> y su detalle.`:'Se borrará lógicamente la solicitud y su detalle.',icon:'warning',showCancelButton:true,confirmButtonText:'Sí, eliminar',cancelButtonText:'Cancelar'})
    .then(r=>{
      if(!r.isConfirmed) return;
      const fd=new FormData(); fd.append('id',id);
      fetch('api/solicitud_delete.php',{method:'POST',body:fd}).then(r=>r.json()).then(j=>{
        if(j?.success){Swal.fire('Éxito','Solicitud eliminada','success'); $('#solicitud').DataTable().ajax.reload(null,false);}
        else{Swal.fire('Error',j?.message||'No se pudo eliminar','error');}
      }).catch(()=>Swal.fire('Error','Error de conexión','error'));
    });
});
</script>

</body>
</html>
