<?php
declare(strict_types=1);
/*
 * imprimir_multiple.php
 * Recibe 'data' por POST (preferido) o GET: JSON de array con objetos:
 * [{ "id": 123, "chasis": "VIN...", "marca": "X", "modelo": "Y", "color": "Rojo" }, ...]
 * Abre iframes a qr/index.php pasando los parámetros que esa vista espera:
 *   id (numérico) e itemdai (VIN) son obligatorios; m, mo, d opcionales.
 */

$dataRaw = $_POST['data'] ?? $_GET['data'] ?? '';
$items = [];
if ($dataRaw !== '') {
  $decoded = json_decode($dataRaw, true);
  if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
    $items = $decoded;
  }
}
if (!$items) {
  exit('No hay datos para imprimir.');
}

function escAttr(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

echo "<!DOCTYPE html><html lang='es'><head><meta charset='utf-8'>";
echo "<title>Impresión múltiple</title>";
echo "<style>body{margin:8px;display:flex;flex-wrap:wrap;gap:8px;align-items:flex-start;justify-content:center}</style>";
echo "</head><body>";

$printed = 0;
foreach ($items as $d) {
  $id     = isset($d['id']) ? (int)$d['id'] : 0;
  $vin    = isset($d['chasis']) ? trim((string)$d['chasis']) : '';
  $marca  = isset($d['marca'])  ? (string)$d['marca']  : '';
  $modelo = isset($d['modelo']) ? (string)$d['modelo'] : '';
  $color  = isset($d['color'])  ? (string)$d['color']  : '';

  if ($id <= 0 || $vin === '') {
    // Omitir silenciosamente los inválidos
    continue;
  }

  // La vista de QR (single) espera estos parámetros:
  // id (numérico), itemdai (VIN), m (marca), mo (modelo), d (color).
  $query = http_build_query([
    'id'      => $id,
    'itemdai' => $vin,
    'm'       => $marca,
    'mo'      => $modelo,
    'd'       => $color,
  ]);

  // Ajusta el nombre del archivo destino si tu single es otro distinto a "index.php".
  $url = "index.php?{$query}";

  echo "<iframe src='".escAttr($url)."' width='280' height='158' style='border:none;'></iframe>";
  $printed++;
}

if ($printed === 0) {
  echo "<div style='color:#b00;font-family:system-ui,Segoe UI,Arial'>No hubo ítems válidos (id y VIN requeridos).</div>";
}
echo "</body></html>";
