<?php
// Loader para PhpSpreadsheet sin Composer desde la carpeta actual (ya dentro de PhpSpreadsheet/)
$base = __DIR__ . '/';

$archivos = [
    'IComparable.php',
    'Spreadsheet.php',
    'IOFactory.php',

    // Reader
    /*'Reader/IReader.php',
    'Reader/BaseReader.php',
    'Reader/Xlsx.php',*/
    // Reader
    'Reader/IReader.php',
    'Reader/BaseReader.php',
    'Reader/Xlsx.php',
    'Reader/Xlsx/Namespaces.php',


    // Writer (si usas exportar luego)
    'Writer/IWriter.php',
    'Writer/BaseWriter.php',
    'Writer/Xlsx.php',

    // Cell & Worksheet
    'Cell/Cell.php',
    'Worksheet/Worksheet.php',
    'Worksheet/Dimension.php',
    'Worksheet/PageSetup.php',
    'Worksheet/Protection.php',
    'Worksheet/AutoFilter.php',
    'Worksheet/HeaderFooter.php',

    // Style
    /*'Style/Style.php',
    'Style/NumberFormat.php',
    'Style/Font.php',
    'Style/Fill.php',
    'Style/Alignment.php',
    'Style/Border.php',
    'Style/Borders.php',
    'Style/Supervisor.php',*/

    // Style (orden correcto)
    'Style/Supervisor.php',      // <-- primero
    'Style/Style.php',
    'Style/NumberFormat.php',
    'Style/Font.php',
    'Style/Fill.php',
    'Style/Alignment.php',
    'Style/Border.php',
    'Style/Borders.php',


    // Shared
    'Shared/StringHelper.php',
    'Shared/File.php',
    'Shared/XMLWriter.php',
    'Shared/Date.php',
    'Shared/CodePage.php',

    // Calculation mínimos
    /*'Calculation/Calculation.php',
    'Calculation/Functions.php'*/
    'Calculation/Functions.php',
    'Calculation/CalculationLocale.php',
    'Calculation/Calculation.php'
];
foreach ($archivos as $file) {
    require_once $base . $file;
}
