<?php
declare(strict_types=1);
require_once __DIR__ . '/conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) die('Sin conexión');
mysqli_set_charset($db,'utf8mb4');
@mysqli_query($db,"SET time_zone='-05:00'");

$id = (int)($_GET['id'] ?? 0);
if ($id<=0) die('ID inválido');

$cabQ = mysqli_query($db, "
  SELECT fi.*,
         CASE WHEN fi.exonerado=1 THEN COALESCE(fi.nombre,'(exonerado)')
              ELSE COALESCE(e.razon_social,'(sin empresa)') END AS cliente
  FROM tb_facturainfo fi
  LEFT JOIN tb_empresa e ON e.idempresa = fi.id_cliente
  WHERE fi.idfacturainfo = {$id}
  LIMIT 1
");
$cab = mysqli_fetch_assoc($cabQ);
if (!$cab) die('No encontrada');

$detQ = mysqli_query($db, "
  SELECT d.*
  FROM detallefactura d
  WHERE d.id_facturainfo = {$id} AND d.condicion=1
  ORDER BY d.iddetallefactura ASC
");
function f2($n){ return number_format((float)$n,2); }
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Factura Informativa #<?= htmlspecialchars((string)$id) ?></title>
<style>
  body{font-family:Arial,sans-serif;font-size:12px}
  .box{border:1px solid #333;padding:8px;border-radius:6px}
  table{width:100%;border-collapse:collapse}
  th,td{border:1px solid #ccc;padding:6px;vertical-align:middle}
  th{background:#f2f2f2}
  .right{text-align:right}.center{text-align:center}.mt-2{margin-top:10px}
  @media print{.no-print{display:none}}
</style>
</head>
<body>
<div class="no-print" style="margin-bottom:10px;">
  <button onclick="window.print()">Imprimir</button>
  <a href="index.php">Volver</a>
</div>

<h3>FACTURA INFORMATIVA</h3>

<div class="box">
  <table>
    <tr>
      <td style="width:50%">
        <strong>Cliente</strong><br>
        <?= htmlspecialchars($cab['cliente'] ?? '') ?><br>
        Identificación: <?= htmlspecialchars($cab['cedula'] ?? '-') ?><br>
      </td>
      <td style="width:50%">
        <strong>Factura</strong><br>
        Nº: <?= htmlspecialchars($cab['numero'] ?? '') ?><br>
        Fecha: <?= htmlspecialchars($cab['fecha'] ?? '') ?><br>
        Pedido: <?= htmlspecialchars($cab['pedido'] ?? '') ?><br>
        Moneda (id): <?= (int)$cab['id_moneda'] ?>
      </td>
    </tr>
  </table>
</div>

<div class="mt-2">
  <table>
    <thead>
      <tr>
        <th>#</th>
        <th>Detalle Nº</th>
        <th class="right">Cant.</th>
        <th class="right">FOB</th>
        <th class="right">Flete</th>
        <th class="right">Seguro</th>
        <th class="right">Valor Aduana</th>
      </tr>
    </thead>
    <tbody>
      <?php $i=1; while($r = mysqli_fetch_assoc($detQ)): ?>
      <tr>
        <td class="center"><?= $i++ ?></td>
        <td><?= htmlspecialchars($r['numerod'] ?? '') ?></td>
        <td class="right"><?= (int)$r['cantidad'] ?></td>
        <td class="right"><?= ($r['valorfob']!==null?  f2($r['valorfob']):'') ?></td>
        <td class="right"><?= ($r['flete']!==null?     f2($r['flete']):'') ?></td>
        <td class="right"><?= ($r['seguro']!==null?     f2($r['seguro']):'') ?></td>
        <td class="right"><?= ($r['valoradua']!==null?  f2($r['valoradua']):'') ?></td>
      </tr>
      <?php endwhile; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="3" class="right">Cantidad</th>
        <th colspan="4"><?= (int)$cab['cantidad'] ?></th>
      </tr>
      <tr>
        <th colspan="3" class="right">Total FOB</th>
        <th class="right"><?= f2($cab['totalfob']) ?></th>
        <th colspan="3"></th>
      </tr>
      <tr>
        <th colspan="3" class="right">Total Flete</th>
        <th class="right"><?= f2($cab['totalflete']) ?></th>
        <th colspan="3"></th>
      </tr>
      <tr>
        <th colspan="3" class="right">Total Seguro</th>
        <th class="right"><?= f2($cab['totalseguro']) ?></th>
        <th colspan="3"></th>
      </tr>
      <tr>
        <th colspan="3" class="right">TOTAL</th>
        <th class="right"><?= f2($cab['total']) ?></th>
        <th colspan="3"></th>
      </tr>
    </tfoot>
  </table>
  <p class="mt-2"><em>Documento informativo sin validez tributaria.</em></p>
</div>
</body>
</html>
