<?php
header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/../conex.php';

try {
    // 👇 ajusta "detallezona" por el nombre correcto en tu tabla
    $sql = "SELECT id, medida
            FROM tb_medida
            WHERE condicion = 1
            ";
    $res = $conn->query($sql);

    $medidas = [];
    while ($row = $res->fetch_assoc()) {
        $medidas[] = $row;
    }

    echo json_encode(['success'=>true,'data'=>$medidas], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Error en la consulta','detail'=>$e->getMessage()]);
}
