<?php
// api/incidente_guardar.php — Inserta en tb_incidente y sube foto (multipart/form-data)
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido']); exit;
}

// (Opcional) Si usas sesión:
// session_start();
// if (($_SESSION['ingreso'] ?? '') !== 'YES') { http_response_code(401); echo json_encode(['success'=>false,'message'=>'No autorizado']); exit; }

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { http_response_code(500); echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

/* Helpers */
function gi(string $k): ?int { return isset($_POST[$k]) && $_POST[$k] !== '' ? (int)$_POST[$k] : null; }
function gs(string $k): ?string { if(!isset($_POST[$k])) return null; $v=trim((string)$_POST[$k]); return $v===''?null:$v; }
function ensure_dir(string $p): void { if (!is_dir($p)) @mkdir($p, 0775, true); }

/* Lee campos */
$id_zona    = gi('id_zona');
$id_parte   = gi('id_parte');
$id_novedad = gi('id_novedad');
$id_tarja   = gi('id_tarja');     // opcional
$id_datadai = gi('id_datadai');
$observacion= gs('observacion');
$id_medida  = gi('id_medida');    // opcional
$medida     = gs('medida');
$validar    = gs('validar');
$condicion  = gi('condicion'); if ($condicion === null) $condicion = 1;

/* Importante: tu columna se llama reponsabilidad (sin 's') */
$reponsabilidad = gs('reponsabilidad');

/* Validaciones mínimas */
$faltan = [];
foreach (['id_zona'=>$id_zona, 'id_parte'=>$id_parte, 'id_novedad'=>$id_novedad, 'id_datadai'=>$id_datadai] as $k=>$v) {
  if ($v === null) $faltan[] = $k;
}
if ($faltan) {
  http_response_code(422);
  echo json_encode(['success'=>false,'message'=>'Campos faltantes o inválidos','faltantes'=>$faltan]); exit;
}

/* Manejo de foto (opcional) */
$fotoRel = null;
if (isset($_FILES['foto']) && (int)$_FILES['foto']['error'] !== UPLOAD_ERR_NO_FILE) {
  $err = (int)$_FILES['foto']['error'];
  if ($err !== UPLOAD_ERR_OK) { http_response_code(400); echo json_encode(['success'=>false,'message'=>'Error al subir la foto','code'=>$err]); exit; }

  $max = 8*1024*1024;
  if ((int)$_FILES['foto']['size'] > $max) { http_response_code(413); echo json_encode(['success'=>false,'message'=>'Imagen > 8MB']); exit; }

  $finfo = new finfo(FILEINFO_MIME_TYPE);
  $mime = $finfo->file($_FILES['foto']['tmp_name']) ?: '';
  $allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/webp'=>'webp'];
  if (!isset($allowed[$mime])) { http_response_code(415); echo json_encode(['success'=>false,'message'=>'Formato no permitido (JPG/PNG/WEBP)']); exit; }
  $ext = $allowed[$mime];

  $yyyy = date('Y'); $mm = date('m');
  $root = realpath(__DIR__ . '/..') ?: dirname(__DIR__);
  $dir  = $root . "/uploads/incidentes/$yyyy/$mm";
  ensure_dir($dir);

  $fname = sprintf('INC-%s-%s.%s', date('Ymd-His'), bin2hex(random_bytes(4)), $ext);
  $dest  = "$dir/$fname";
  if (!@move_uploaded_file($_FILES['foto']['tmp_name'], $dest)) {
    http_response_code(500); echo json_encode(['success'=>false,'message'=>'No se pudo mover la imagen']); exit;
  }
  // Ruta RELATIVA para servir desde webroot
  $fotoRel = "uploads/incidentes/$yyyy/$mm/$fname";
}

/* Inserta */
$sql = "INSERT INTO tb_incidente
  (id_zona, id_parte, id_novedad, id_tarja, id_datadai, observacion, id_medida, medida, foto, reponsabilidad, validar, condicion)
  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
$stmt = $db->prepare($sql);
if (!$stmt) { http_response_code(500); echo json_encode(['success'=>false,'message'=>'Prepare error','error'=>$db->error]); exit; }

/* Tipos: i=int, s=string */
$stmt->bind_param(
  'iiiiisissssi',
  $id_zona,
  $id_parte,
  $id_novedad,
  $id_tarja,        // puede ser null, MySQLi enviará NULL si la variable es null
  $id_datadai,
  $observacion,     // null permitido
  $id_medida,       // null permitido
  $medida,          // null permitido
  $fotoRel,         // null permitido
  $reponsabilidad,  // null permitido
  $validar,         // null permitido
  $condicion
);

if (!$stmt->execute()) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error al insertar','error'=>$stmt->error]); exit;
}

$id = (int)$db->insert_id;
$stmt->close();

echo json_encode([
  'success' => true,
  'message' => 'Incidente registrado',
  'idincidente' => $id,
  'foto' => $fotoRel
]);
