<?php
// api/solicitud_update.php — actualiza SP y campos relacionados (incluye pedido/naviera)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

$pathConex = realpath(__DIR__ . '/../conex.php') ?: realpath(__DIR__ . '/../../conex.php');
if (!$pathConex) { echo json_encode(['success'=>false,'message'=>'No se encontró conex.php']); exit; }
require_once $pathConex;

$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');

function str($k){ return trim((string)($_POST[$k] ?? '')); }
function i($k){ return (int)($_POST[$k] ?? 0); }

$id              = i('id');
$idempresa       = i('idempresa');
$id_localidad    = i('id_localidad');
$codigo          = strtoupper(str('codigo'));
$anio            = str('anio');
$numero          = strtoupper(str('numero'));

// En tu BD real:
$codigo_embarque = strtoupper(str('codigo_embarque')); // mapeará a sp.cod_embarque
$fecha_emision   = str('fecha_emision');                // mapeará a sp.fecha

$id_categoria    = i('id_categoria');
$pedido          = str('pedido');                       // NUEVO
$naviera         = str('naviera');                      // NUEVO

$dai             = strtoupper(str('daie'));             // tb_daientrada.numerodai
$fechae          = str('fechae');                       // tb_daientrada.fecha
$fechaev         = str('fechaev');                      // tb_daientrada.fecha_v
$id_bodega       = i('bodega');                         // tb_daientrada.id_bodega

$sp_compuesto    = strtoupper(str('sp'));               // COD-ANIO-NUM

if ($id<=0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

$db->begin_transaction();

try {
  // ====== UPDATE tb_solicitudprevia ======
  $sqlSp = "UPDATE tb_solicitudprevia SET
              id_empresa     = ?,
              id_localidad   = ?,
              codigo         = ?,
              anio           = ?,
              numero         = ?,
              cod_embarque   = ?,   -- <- tu columna real
              fecha          = ?,   -- <- tu columna real (antes llamada fecha_emision)
              id_categoria   = ?,
              pedido         = ?,   -- NUEVO
              naviera        = ?,   -- NUEVO
              numerosp       = ?
            WHERE idsolicitudprevia = ? AND condicion = 1";
  $stmt = $db->prepare($sqlSp);
  if (!$stmt) throw new Exception('Error preparando actualización de SP: '.$db->error);

  $stmt->bind_param(
    'iisssssssssi',
    $idempresa,
    $id_localidad,
    $codigo,
    $anio,
    $numero,
    $codigo_embarque,
    $fecha_emision,
    $id_categoria,
    $pedido,
    $naviera,
    $sp_compuesto,
    $id
  );
  if (!$stmt->execute()) throw new Exception('No se pudo actualizar SP: '.$stmt->error);
  $stmt->close();

  // ====== UPSERT tb_daientrada (si llega info) ======
  // Si no envías alguno de estos, omite el upsert.
  if ($dai !== '' || $fechae !== '' || $fechaev !== '' || $id_bodega > 0) {
    // Intentar UPDATE; si no existe, INSERT
    // Requiere índice único por id_solicitudprevia en tb_daientrada para ON DUPLICATE KEY.
    // Si no lo tienes, hacemos lógica manual:
    $sqlCheck = "SELECT id FROM tb_daientrada WHERE id_solicitudprevia = ? LIMIT 1";
    $chk = $db->prepare($sqlCheck); $chk->bind_param('i',$id); $chk->execute();
    $has = $chk->get_result()->fetch_assoc(); $chk->close();

    if ($has) {
      $sqlUp = "UPDATE tb_daientrada SET
                  numerodai = ?,
                  fecha     = ?,   -- real
                  fecha_v   = ?,   -- real
                  id_bodega = ?
                WHERE id_solicitudprevia = ?";
      $up = $db->prepare($sqlUp);
      if (!$up) throw new Exception('Error preparando actualización DAI entrada: '.$db->error);
      $up->bind_param('sssii', $dai, $fechae, $fechaev, $id_bodega, $id);
      if (!$up->execute()) throw new Exception('No se pudo actualizar DAI entrada: '.$up->error);
      $up->close();
    } else {
      $sqlIn = "INSERT INTO tb_daientrada (id_solicitudprevia, numerodai, fecha, fecha_v, id_bodega, condicion)
                VALUES (?, ?, ?, ?, ?, 1)";
      $in = $db->prepare($sqlIn);
      if (!$in) throw new Exception('Error preparando inserción DAI entrada: '.$db->error);
      $in->bind_param('isssi', $id, $dai, $fechae, $fechaev, $id_bodega);
      if (!$in->execute()) throw new Exception('No se pudo insertar DAI entrada: '.$in->error);
      $in->close();
    }
  }

  $db->commit();
  echo json_encode(['success'=>true,'message'=>'Actualizado']);

} catch (Throwable $ex) {
  $db->rollback();
  echo json_encode(['success'=>false,'message'=>$ex->getMessage()]);
}
