<?php
// api/solicitud_delete.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

mysqli_set_charset($db, 'utf8mb4');
$db->begin_transaction();
try {
  // hijos primero
  if (!$st1 = $db->prepare("UPDATE tb_datadai SET condicion=0 WHERE id_solicitudprevia=?")) {
    throw new Exception('Prepare datadai: '.$db->error);
  }
  $st1->bind_param('i', $id);
  if (!$st1->execute()) throw new Exception('Exec datadai: '.$st1->error);
  $st1->close();

  if (!$st2 = $db->prepare("UPDATE tb_daientrada SET condicion=0 WHERE id_solicitudprevia=?")) {
    throw new Exception('Prepare daientrada: '.$db->error);
  }
  $st2->bind_param('i', $id);
  if (!$st2->execute()) throw new Exception('Exec daientrada: '.$st2->error);
  $st2->close();

  // cabecera
  if (!$st3 = $db->prepare("UPDATE tb_solicitudprevia SET condicion=0 WHERE idsolicitudprevia=?")) {
    throw new Exception('Prepare solicitudprevia: '.$db->error);
  }
  $st3->bind_param('i', $id);
  if (!$st3->execute()) throw new Exception('Exec solicitudprevia: '.$st3->error);
  $st3->close();

  $db->commit();
  echo json_encode(['success'=>true,'message'=>'Eliminado correctamente']);
} catch (Throwable $e) {
  $db->rollback();
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
