<?php
// api/reparaciones_list_min.php — lista mínima (5 columnas) sin chasis repetidos
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  echo json_encode(['success'=>false,'data'=>[]]); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'data'=>[]]); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

/*
  Tablas:
  - tb_datadai (iddatadai, marca, modelo, color, chasis, dai, condicion)
  - tb_reparacion (id_reparacion, id_datadai, fecha_programada)
  - tb_incidente (id_incidente, id_datadai, ...)
*/

$sql = "
  SELECT
    d.marca,
    d.modelo,
    d.chasis,
    d.color,
    DATE_FORMAT(rr.fecha_programada, '%Y-%m-%d %H:%i') AS fecha_programada
  FROM tb_datadai AS d
  LEFT JOIN (
    SELECT id_datadai, MAX(fecha_programada) AS fecha_programada
    FROM tb_reparacion
    GROUP BY id_datadai
  ) AS rr ON rr.id_datadai = d.iddatadai
  WHERE d.condicion = 1
    AND d.dai = 'Simple'
    AND EXISTS (SELECT 1 FROM tb_incidente i WHERE i.id_datadai = d.iddatadai)
  ORDER BY (rr.fecha_programada IS NULL), rr.fecha_programada DESC, d.chasis
  LIMIT 10000
";

$rs = mysqli_query($db, $sql);
if (!$rs) { echo json_encode(['success'=>false,'data'=>[], 'sql_error'=>mysqli_error($db)]); exit; }

$data = [];
while ($row = mysqli_fetch_assoc($rs)) {
  $data[] = [
    'marca'            => $row['marca'] ?? '',
    'modelo'           => $row['modelo'] ?? '',
    'chasis'           => $row['chasis'] ?? '',
    'color'            => $row['color'] ?? '',
    'fecha_programada' => $row['fecha_programada'] ?? ''
  ];
}
echo json_encode(['success'=>true,'data'=>$data,'count'=>count($data)]);
