<?php
// api/parte_list.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn, 'utf8mb4');

$search = trim((string)($_GET['search'] ?? ''));

$sql = "SELECT id_parte, nombre, IFNULL(condicion,1) AS condicion
        FROM tb_inv_parte
        WHERE 1=1";
$params = []; $types = '';

if ($search !== '') {
  $sql .= " AND (nombre LIKE CONCAT('%',?,'%'))";
  $params[] = $search; $types .= 's';
}
$sql .= " ORDER BY nombre ASC";

$stmt = mysqli_prepare($conn, $sql);
if ($params) mysqli_stmt_bind_param($stmt, $types, ...$params);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$data = [];
while ($row = mysqli_fetch_assoc($res)) $data[] = $row;

echo json_encode(['success'=>true,'data'=>$data]);
