<?php
// api/modelo_save.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id_modelo = (int)($in['id_modelo'] ?? 0);
$id_marca  = (int)($in['id_marca'] ?? 0);
$nombre    = trim((string)($in['nombre'] ?? ''));
$anio      = $in['anio'] ?? null;
$condicion = isset($in['condicion']) ? (int)$in['condicion'] : 1;

if ($id_marca <= 0) { echo json_encode(['success'=>false,'message'=>'Marca requerida']); exit; }
if ($nombre === '') { echo json_encode(['success'=>false,'message'=>'Modelo requerido']); exit; }
if ($anio !== null && $anio !== '' && !is_numeric($anio)) { echo json_encode(['success'=>false,'message'=>'Año inválido']); exit; }
$anio = ($anio === '' || $anio === null) ? null : (int)$anio;
if ($anio !== null && ($anio < 1900 || $anio > 2100)) { echo json_encode(['success'=>false,'message'=>'Año fuera de rango']); exit; }
if ($condicion !== 0 && $condicion !== 1) $condicion = 1;

if ($id_modelo > 0) {
  $stmt = mysqli_prepare($conn,"UPDATE tb_inv_modelo SET id_marca=?, nombre=?, anio=?, condicion=? WHERE id_modelo=?");
  if ($anio === null) {
    mysqli_stmt_bind_param($stmt,'isiii',$id_marca,$nombre,$anio,$condicion,$id_modelo); // anio NULL ok
  } else {
    mysqli_stmt_bind_param($stmt,'isiii',$id_marca,$nombre,$anio,$condicion,$id_modelo);
  }
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_marca_modelo_anio')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe ese Modelo/Año en la marca seleccionada']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al actualizar']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Actualizado']);
} else {
  $stmt = mysqli_prepare($conn,"INSERT INTO tb_inv_modelo (id_marca, nombre, anio, condicion) VALUES (?,?,?,?)");
  if ($anio === null) {
    mysqli_stmt_bind_param($stmt,'issi',$id_marca,$nombre,$anio,$condicion);
  } else {
    mysqli_stmt_bind_param($stmt,'issi',$id_marca,$nombre,$anio,$condicion);
  }
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_marca_modelo_anio')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe ese Modelo/Año en la marca seleccionada']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al crear']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Creado','id'=>mysqli_insert_id($conn)]);
}
