<?php
// lavada_save_strict.php — Actualiza la última fila o inserta si no existe
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$idpdi  = (int)($in['idpdi'] ?? 0);
$idtipo = (int)($in['idtipo_lavada'] ?? 0);
$idUsuario = (int)($_SESSION['idusuario'] ?? 0);

if ($idpdi <= 0 || $idtipo <= 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}

$stVal = $db->prepare("SELECT COUNT(*) c FROM tb_tipolavada WHERE idtipo_lavada=? AND condicion=1");
$stVal->bind_param('i', $idtipo);
$stVal->execute();
if (!((int)$stVal->get_result()->fetch_assoc()['c'])) {
  echo json_encode(['success'=>false,'message'=>'Tipo de lavada inválido']); exit;
}

$stP = $db->prepare("SELECT id_datadai FROM tb_pdi WHERE idpdi=? AND condicion=1");
$stP->bind_param('i', $idpdi);
$stP->execute();
$row = $stP->get_result()->fetch_assoc();
if (!$row) { echo json_encode(['success'=>false,'message'=>'Requerimiento no encontrado']); exit; }
$idDatadai = (int)$row['id_datadai'];

$db->begin_transaction();

// Tomar la fila más reciente (si existe)
$stGet = $db->prepare("
  SELECT idlavada, id_tipolavada 
  FROM tb_lavada 
  WHERE id_datadai=? 
  ORDER BY fecha_registro DESC, idlavada DESC
  LIMIT 1
");
$stGet->bind_param('i', $idDatadai);
$stGet->execute();
$cur = $stGet->get_result()->fetch_assoc();

if ($cur) {
  if ((int)$cur['id_tipolavada'] === $idtipo) {
    $db->commit();
    echo json_encode(['success'=>true,'action'=>'noop','message'=>'Sin cambios']); exit;
  }
  // Actualizar SOLO la última
  $stUpd = $db->prepare("
    UPDATE tb_lavada
    SET id_tipolavada=?, id_usuario=?, fecha_registro=NOW(), condicion=1
    WHERE idlavada=?
    LIMIT 1
  ");
  $stUpd->bind_param('iii', $idtipo, $idUsuario, $cur['idlavada']);
  if (!$stUpd->execute()) { $db->rollback(); echo json_encode(['success'=>false,'message'=>'No se pudo actualizar','sql_error'=>$db->error]); exit; }
  $db->commit();
  echo json_encode(['success'=>true,'action'=>'update']); exit;
} else {
  // No existe: insertar
  $stIns = $db->prepare("
    INSERT INTO tb_lavada (id_datadai, fecha_registro, id_tipolavada, id_usuario, condicion)
    VALUES (?, NOW(), ?, ?, 1)
  ");
  $stIns->bind_param('iii', $idDatadai, $idtipo, $idUsuario);
  if (!$stIns->execute()) { $db->rollback(); echo json_encode(['success'=>false,'message'=>'No se pudo insertar','sql_error'=>$db->error]); exit; }
  $db->commit();
  echo json_encode(['success'=>true,'action'=>'insert']); exit;
}
