<?php
declare(strict_types=1);

error_reporting(E_ALL);
ini_set('display_errors','0'); // no contaminar JSON
ob_start();

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { ob_end_clean(); echo json_encode(['data'=>[], 'message'=>'Sin conexión']); exit; }

mysqli_set_charset($db,'utf8mb4');
@mysqli_query($db,"SET time_zone='-05:00'");

/*
  Esquema usado:
  tb_facturainfo(idfacturainfo, numero, fecha, id_cliente, exonerado, nombre, id_solicitud_previa, id_dai, id_estado, condicion)
  tb_empresa(idempresa, razon_social)
  NOTA: NO usamos f.pedido ni f.creado_en para evitar 500.
*/
$sql = "
SELECT
    f.idfacturainfo,
    f.numero AS nro,
    f.fecha,
    f.id_cliente,
    sp.pedido,
    sp.numerosp AS sp,
    sp.cod_embarque,
    sp.tributo,
    de.numerodai AS dai,
    e.razon_social AS cliente
FROM tb_facturainfo AS f
LEFT JOIN tb_empresa AS e
    ON e.idempresa = f.id_cliente
INNER JOIN tb_solicitudprevia AS sp
    ON sp.idsolicitudprevia = f.id_solicitud_previa
INNER JOIN tb_daientrada AS de
    ON de.id_solicitudprevia = sp.idsolicitudprevia
WHERE f.condicion = 1
  AND f.id_estado >= 5 and f.id_estado <= 6
";

$q = mysqli_query($db, $sql);
if (!$q) {
  $err = mysqli_error($db);
  ob_end_clean();
  echo json_encode(['data'=>[], 'message'=>"SQL error: $err"]);
  exit;
}

$data = [];
while ($r = mysqli_fetch_assoc($q)) {
  // Sanitizar por seguridad en caso de que algo venga con caracteres especiales
  $idfactura = (int)($r['idfacturainfo'] ?? 0);

  // Botón de acción (usar $r, no $row)
  $r['accion'] = 
    '<div class="btn-group btn-group-sm">'.
      '<a class="btn btn-outline-primary" href="../../pdf/facturainformativa.php?idfactura='.$idfactura.'" title="Ver/Imprimir">'.
        '<i class="fa fa-print"></i>'.
      '</a>'.
    '</div>';

  $data[] = $r;
}

ob_end_clean();
echo json_encode(['data'=>$data], JSON_UNESCAPED_UNICODE);
