<?php
// api/directa_item_info.php — Ítems (chasis) por DAI de entrada (por id_daientrada o numerodai)
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* ==== Cargar conex.php de forma robusta ==== */
$pathConex = null;
foreach ([__DIR__.'/conex.php', dirname(__DIR__).'/conex.php', __DIR__.'/../conex.php'] as $p) {
  if (is_file($p)) { $pathConex = $p; break; }
}
if (!$pathConex) { echo json_encode(['success'=>false,'message'=>'No se encontró conex.php','data'=>[]]); exit; }
require_once $pathConex;

/* ==== Conexión ==== */
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos','data'=>[]]); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/* ==== Parámetros ==== */
$iddaien = (int)($_GET['iddaien'] ?? $_GET['id'] ?? 0);
$daiNum  = trim((string)($_GET['dai'] ?? ''));

/* ==== SQL base ==== */
$sqlBase = "
SELECT
  d.iddatadai        AS id,
  d.item,
  d.chasis,
  d.marca,
  d.modelo,
  d.color,
  d.motor,
  d.id_estado        AS estado,
  d.dai,
  d.fecha_ingreso,
  e.numerodai        AS numerodai,
  emp.razon_social   AS empresa,
  emp.ruc            AS ruc,
  bod.detalle        AS bodega,
  ub.detalle_ubicacion AS ubicacion
FROM tb_datadai d
JOIN tb_daientrada e   ON e.iddaientrada = d.id_daientrada
LEFT JOIN tb_solicitudprevia sp ON sp.idsolicitudprevia = e.id_solicitudprevia
LEFT JOIN tb_empresa emp        ON emp.idempresa = sp.id_empresa
LEFT JOIN tb_bodega bod         ON bod.idbodega = e.id_bodega
LEFT JOIN tb_ubicacion ub       ON ub.idubicacion = d.id_ubicacion
WHERE d.condicion = 1
";

/* ==== Elegir filtro por id o por numerodai ==== */
$rows = [];
if ($iddaien > 0) {
  $sql = $sqlBase . " AND d.id_daientrada = ? ORDER BY d.item ASC, d.iddatadai ASC";
  $stmt = mysqli_prepare($db, $sql);
  if (!$stmt) { echo json_encode(['success'=>false,'message'=>'Error SQL (prepare): '.mysqli_error($db),'data'=>[]]); exit; }
  mysqli_stmt_bind_param($stmt, 'i', $iddaien);

} elseif ($daiNum !== '') {
  $sql = $sqlBase . " AND e.numerodai = ? ORDER BY d.item ASC, d.iddatadai ASC";
  $stmt = mysqli_prepare($db, $sql);
  if (!$stmt) { echo json_encode(['success'=>false,'message'=>'Error SQL (prepare): '.mysqli_error($db),'data'=>[]]); exit; }
  mysqli_stmt_bind_param($stmt, 's', $daiNum);

} else {
  echo json_encode(['success'=>false,'message'=>'Parámetro requerido: iddaien (o id) o dai','data'=>[]]); exit;
}

/* ==== Ejecutar ==== */
if (!mysqli_stmt_execute($stmt)) {
  echo json_encode(['success'=>false,'message'=>'Error SQL (execute): '.mysqli_error($db),'data'=>[]]); exit;
}

/* ==== Mapeo de estado (opcional UI) ==== */
function estado_map(int $st): array {
  switch ($st) {
    case 1: return ['Pendiente', 'text-bg-secondary'];
    case 2: return ['En proceso', 'text-bg-warning'];
    case 3: return ['Listo', 'text-bg-success'];
    default: return ["Estado $st", 'text-bg-info'];
  }
}

/* ==== Construir respuesta ==== */
if (function_exists('mysqli_stmt_get_result')) {
  $res = mysqli_stmt_get_result($stmt);
  while ($r = mysqli_fetch_assoc($res)) {
    $st = (int)($r['estado'] ?? 0);
    [$txt, $badge] = estado_map($st);
    $rows[] = [
      'id'            => (int)$r['id'],
      'item'          => (int)($r['item'] ?? 0),
      'chasis'        => (string)($r['chasis'] ?? ''),
      'marca'         => (string)($r['marca'] ?? ''),
      'modelo'        => (string)($r['modelo'] ?? ''),
      'color'         => (string)($r['color'] ?? ''),
      'motor'         => (string)($r['motor'] ?? ''),
      'estado'        => $st,
      'estado_txt'    => $txt,
      'estado_badge'  => $badge,
      'dai'           => (string)($r['dai'] ?? ''),
      'fecha_ingreso' => (string)($r['fecha_ingreso'] ?? ''),
      'numerodai'     => (string)($r['numerodai'] ?? ''),
      'empresa'       => (string)($r['empresa'] ?? ''),
      'ruc'           => (string)($r['ruc'] ?? ''),
      'bodega'        => (string)($r['bodega'] ?? ''),
      'ubicacion'     => (string)($r['ubicacion'] ?? ''),
    ];
  }
} else {
  mysqli_stmt_store_result($stmt);
  mysqli_stmt_bind_result(
    $stmt,
    $id,$item,$chasis,$marca,$modelo,$color,$motor,$estado,$dai,$fecha_ingreso,
    $numerodai,$empresa,$ruc,$bodega,$ubicacion
  );
  while (mysqli_stmt_fetch($stmt)) {
    [$txt, $badge] = estado_map((int)$estado);
    $rows[] = [
      'id'            => (int)$id,
      'item'          => (int)$item,
      'chasis'        => (string)$chasis,
      'marca'         => (string)$marca,
      'modelo'        => (string)$modelo,
      'color'         => (string)$color,
      'motor'         => (string)$motor,
      'estado'        => (int)$estado,
      'estado_txt'    => $txt,
      'estado_badge'  => $badge,
      'dai'           => (string)$dai,
      'fecha_ingreso' => (string)$fecha_ingreso,
      'numerodai'     => (string)$numerodai,
      'empresa'       => (string)$empresa,
      'ruc'           => (string)$ruc,
      'bodega'        => (string)$bodega,
      'ubicacion'     => (string)$ubicacion,
    ];
  }
}
mysqli_stmt_close($stmt);

/* ==== Salida ==== */
echo json_encode(['success'=>true,'data'=>$rows], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
