<?php
// api/categoria_save.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
// if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') { http_response_code(401); echo json_encode(['success'=>false,'message'=>'No autorizado']); exit; }

require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id = (int)($in['id_categoria'] ?? 0);
$nombre = trim((string)($in['nombre'] ?? ''));
$condicion = isset($in['condicion']) ? (int)$in['condicion'] : 1;

if ($nombre === '') { echo json_encode(['success'=>false,'message'=>'El nombre es obligatorio']); exit; }
if ($condicion !== 0 && $condicion !== 1) { $condicion = 1; }

if ($id > 0) {
  // Update
  $sql = "UPDATE tb_inv_categoria SET nombre = ?, condicion = ? WHERE id_categoria = ?";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, 'sii', $nombre, $condicion, $id);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err, 'uq_categoria_nombre')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una categoría con ese nombre']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al actualizar']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Actualizado']);
} else {
  // Insert
  $sql = "INSERT INTO tb_inv_categoria (nombre, condicion) VALUES (?, ?)";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, 'si', $nombre, $condicion);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err, 'uq_categoria_nombre')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una categoría con ese nombre']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al crear']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Creado','id'=>mysqli_insert_id($conn)]);
}
