<?php
// api/bodega_origen.php — Lista de bodegas activas (opcional: con stock)
// GET params:
//   q=texto (opcional)
//   onlyWithStock=1 (opcional) -> solo bodegas con stock > 0
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$q   = trim((string)($_GET['q'] ?? ''));
$ows = (int)($_GET['onlyWithStock'] ?? 0);

$sql = "
  SELECT b.id_bodega, b.nombre, b.ciudad, b.direccion
  FROM tb_inv_bodega b
  WHERE IFNULL(b.condicion,1)=1
";
$params=[]; $types='';

if ($q !== '') {
  $sql .= " AND (b.nombre LIKE CONCAT('%',?,'%')
             OR IFNULL(b.ciudad,'') LIKE CONCAT('%',?,'%')
             OR IFNULL(b.direccion,'') LIKE CONCAT('%',?,'%'))";
  $params[]=$q; $params[]=$q; $params[]=$q; $types.='sss';
}

if ($ows === 1) {
  // Solo bodegas con stock total > 0
  $sql .= " AND EXISTS (
              SELECT 1 FROM tb_inv_stock s
              WHERE s.id_bodega = b.id_bodega
                AND s.stock > 0
            )";
}

$sql .= " ORDER BY b.nombre ASC";

$stmt = mysqli_prepare($conn,$sql);
if ($params) mysqli_stmt_bind_param($stmt,$types,...$params);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$data=[];
while($row=mysqli_fetch_assoc($res)) $data[]=$row;

echo json_encode(['success'=>true,'data'=>$data]);
