<?php
// api/accesorizacion_leer.php
// Entrada: ?chasis=XXXX
// Salida: { success:true, data:["3","7",...] }  ← IDs activos (estado_acces=1)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require_once __DIR__ . '/../conex.php';

$chasis = isset($_GET['chasis']) ? trim((string)$_GET['chasis']) : '';

try{
  if ($chasis==='') throw new InvalidArgumentException('chasis requerido');
  if (!isset($conn) || !($conn instanceof mysqli)) throw new RuntimeException('Sin conexión BD');
  mysqli_set_charset($conn,'utf8mb4');

  // 1) id_datadai por chasis
  $q = "SELECT iddatadai FROM tb_datadai WHERE chasis=? AND condicion=1 LIMIT 1";
  $st = mysqli_prepare($conn,$q);
  mysqli_stmt_bind_param($st,'s',$chasis);
  mysqli_stmt_execute($st);
  $res = mysqli_stmt_get_result($st);
  $idd = 0;
  if ($r = mysqli_fetch_assoc($res)) $idd = (int)$r['iddatadai'];
  if ($idd<=0){ echo json_encode(['success'=>true,'data'=>[]]); exit; }

  // 2) Leer accesorios activos para ese id_datadai
  $q2 = "SELECT id_accesorios FROM tb_accesorizacion WHERE id_datadai=? AND estado_acces=1";
  $st2 = mysqli_prepare($conn,$q2);
  mysqli_stmt_bind_param($st2,'i',$idd);
  mysqli_stmt_execute($st2);
  $res2 = mysqli_stmt_get_result($st2);

  $ids=[];
  while($row = mysqli_fetch_assoc($res2)){
    $ids[] = (string)((int)$row['id_accesorios']);
  }

  echo json_encode(['success'=>true,'data'=>$ids], JSON_UNESCAPED_UNICODE);
}catch(Throwable $e){
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
