<?php
// api/accesorio_list.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$search      = trim((string)($_GET['search'] ?? ''));
$id_categoria= (int)($_GET['id_categoria'] ?? 0);
$soloActivos = (int)($_GET['soloActivos'] ?? 0); // 1 = sólo condicion=1

$sql = "SELECT a.id_accesorio, a.sku, a.nombre, a.id_categoria, c.nombre AS categoria,
               a.descripcion, a.unidad_medida, a.codigo_barras,
               a.attrs, a.stock_min, a.stock_max, IFNULL(a.activo,1) AS activo,
               a.created_at, IFNULL(a.condicion,1) AS condicion
        FROM tb_inv_accesorio a
        JOIN tb_inv_categoria c ON c.id_categoria = a.id_categoria
        WHERE 1=1";
$params=[]; $types='';

if ($id_categoria>0) { $sql.=" AND a.id_categoria=?"; $params[]=$id_categoria; $types.='i'; }
if ($soloActivos===1){ $sql.=" AND IFNULL(a.condicion,1)=1"; }
if ($search!=='') {
  $sql.=" AND (a.sku LIKE CONCAT('%',?,'%')
           OR a.nombre LIKE CONCAT('%',?,'%')
           OR c.nombre LIKE CONCAT('%',?,'%')
           OR IFNULL(a.codigo_barras,'') LIKE CONCAT('%',?,'%'))";
  array_push($params,$search,$search,$search,$search); $types.='ssss';
}
$sql.=" ORDER BY c.nombre ASC, a.nombre ASC";

$stmt = mysqli_prepare($conn,$sql);
if ($params) mysqli_stmt_bind_param($stmt,$types,...$params);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$data=[];
while($row=mysqli_fetch_assoc($res)){
  // attrs como string (por si el front lo muestra/edita)
  if (!is_null($row['attrs'])) $row['attrs'] = (string)$row['attrs'];
  $data[]=$row;
}
echo json_encode(['success'=>true,'data'=>$data]);
