<?php
// api/accesorio_ingreso_save.php — Guarda accesorio + partes + compatibilidad + ingreso stock
declare(strict_types=1);
ini_set('display_errors','0'); ini_set('log_errors','1');
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD']==='OPTIONS'){ http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
if (!$in) { echo json_encode(['success'=>false,'message'=>'JSON inválido']); exit; }

$acc  = $in['accesorio'] ?? [];
$partes = $in['partes'] ?? [];
$comps  = $in['compatibilidades'] ?? [];
$ing    = $in['ingreso'] ?? [];

$sku = trim((string)($acc['sku'] ?? ''));
$nombre = trim((string)($acc['nombre'] ?? ''));
$id_categoria = (int)($acc['id_categoria'] ?? 0);
if ($sku==='' || $nombre==='' || $id_categoria<=0){
  echo json_encode(['success'=>false,'message'=>'Faltan campos obligatorios (sku, nombre, categoría)']); exit;
}

// ingreso requerido
$id_bodega = (int)($ing['id_bodega'] ?? 0);
$cantidad  = (float)($ing['cantidad'] ?? 0);
$id_usuario= (int)($ing['id_usuario'] ?? 0);
if ($id_bodega<=0 || !($cantidad>0)){
  echo json_encode(['success'=>false,'message'=>'Bodega y cantidad son obligatorios']); exit;
}

$descripcion   = (string)($acc['descripcion'] ?? '');
$unidad_medida = (string)($acc['unidad_medida'] ?? '');
$codigo_barras = (string)($acc['codigo_barras'] ?? '');
$attrs         = (string)($acc['attrs'] ?? '');
$stock_min     = (int)($acc['stock_min'] ?? 0);
$stock_max     = (int)($acc['stock_max'] ?? 0);
$activo        = (int)($acc['activo'] ?? 1);
$condicion     = 1;
$id_ubicacion  = isset($ing['id_ubicacion']) && $ing['id_ubicacion'] ? (int)$ing['id_ubicacion'] : null;
$motivo        = (string)($ing['motivo'] ?? 'Ingreso inicial');
$ref_tipo      = (string)($ing['ref_tipo'] ?? '');
$ref_id        = (string)($ing['ref_id'] ?? '');

try{
  mysqli_begin_transaction($conn);

  // no duplicar SKU
  $st = mysqli_prepare($conn, "SELECT id_accesorio FROM tb_inv_accesorio WHERE sku=? LIMIT 1");
  mysqli_stmt_bind_param($st,'s',$sku); mysqli_stmt_execute($st);
  $res = mysqli_stmt_get_result($st); $dup = mysqli_fetch_assoc($res); mysqli_stmt_close($st);
  if ($dup) { throw new Exception('SKU ya existe'); }

  // validar attrs JSON si viene
  if ($attrs !== '') {
    json_decode($attrs);
    if (json_last_error() !== JSON_ERROR_NONE) { throw new Exception('Atributos no es JSON válido'); }
  }

  // insertar accesorio
  $sql = "INSERT INTO tb_inv_accesorio
          (sku, nombre, id_categoria, descripcion, unidad_medida, codigo_barras, attrs, stock_min, stock_max, activo, created_at, condicion)
          VALUES (?,?,?,?,?,?,?,?,?,?,NOW(),?)";
  $st = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($st,'ssissssiiii',
    $sku, $nombre, $id_categoria, $descripcion, $unidad_medida, $codigo_barras, $attrs,
    $stock_min, $stock_max, $activo, $condicion
  );
  if (!mysqli_stmt_execute($st)) throw new Exception('No se pudo insertar accesorio');
  $id_accesorio = (int)mysqli_insert_id($conn);
  mysqli_stmt_close($st);

  // partes (evita duplicados)
  if (is_array($partes) && count($partes)>0){
    $st = mysqli_prepare($conn, "INSERT IGNORE INTO tb_inv_accesorio_parte (id_accesorio, id_parte) VALUES (?,?)");
    foreach($partes as $id_parte){
      $id_parte = (int)$id_parte; if ($id_parte<=0) continue;
      mysqli_stmt_bind_param($st,'ii',$id_accesorio,$id_parte);
      mysqli_stmt_execute($st);
    }
    mysqli_stmt_close($st);
  }

  // compatibilidad (id_modelo + años opcionales) — evita duplicado exacto
  if (is_array($comps) && count($comps)>0){
    $st = mysqli_prepare($conn, "INSERT IGNORE INTO tb_inv_compatibilidad (id_accesorio, id_modelo, anio_desde, anio_hasta, observacion)
                                 VALUES (?,?,?,?,?)");
    foreach($comps as $c){
      $id_modelo  = (int)($c['id_modelo'] ?? 0); if ($id_modelo<=0) continue;
      $anio_desde = isset($c['anio_desde']) && $c['anio_desde']!=='' ? (int)$c['anio_desde'] : null;
      $anio_hasta = isset($c['anio_hasta']) && $c['anio_hasta']!=='' ? (int)$c['anio_hasta'] : null;
      $obs        = (string)($c['observacion'] ?? '');
      // bind con nulls
      mysqli_stmt_bind_param($st,'iiiss', $id_accesorio, $id_modelo, $anio_desde, $anio_hasta, $obs);
      mysqli_stmt_execute($st);
    }
    mysqli_stmt_close($st);
  }

  // movimiento IN (usa tus tablas de movimiento para reflejar stock)
  $tipo = 'IN';
  $fecha = date('Y-m-d H:i:s');
  $st = mysqli_prepare($conn, "INSERT INTO tb_inv_movimiento
              (fecha, tipo, id_bodega_origen, id_bodega_destino, motivo, ref_tipo, ref_id, id_usuario)
              VALUES (?,?,NULL,?,?,?,?,?)");
  mysqli_stmt_bind_param($st,'sss ss si',
    $fecha, $tipo, $id_bodega, $motivo, $ref_tipo, $ref_id, $id_usuario
  );
  // Arriba hay espacios en el type string — lo corregimos:
  mysqli_stmt_close($st);
  $st = mysqli_prepare($conn, "INSERT INTO tb_inv_movimiento
              (fecha, tipo, id_bodega_origen, id_bodega_destino, motivo, ref_tipo, ref_id, id_usuario)
              VALUES (?,?,NULL,?,?,?,?,?)");
  mysqli_stmt_bind_param($st,'sss ss si', $fecha, $tipo, $id_bodega, $motivo, $ref_tipo, $ref_id, $id_usuario);
  // El anterior aún queda confuso por espacios. Vamos a dividir en variables y bind correcto:
  mysqli_stmt_close($st);
  $sqlMov = "INSERT INTO tb_inv_movimiento
              (fecha, tipo, id_bodega_origen, id_bodega_destino, motivo, ref_tipo, ref_id, id_usuario)
             VALUES (?,?,NULL,?,?,?,?,?)";
  $st = mysqli_prepare($conn, $sqlMov);
  mysqli_stmt_bind_param($st,'sss ss si',
    $fecha, $tipo, $id_bodega, $motivo, $ref_tipo, $ref_id, $id_usuario
  );
  // Para evitar problemas con los espacios en el 'types', reescribimos correctamente:
  mysqli_stmt_close($st);
  $st = mysqli_prepare($conn, $sqlMov);
  // tipos: fecha(s), tipo(s), id_bodega(i), motivo(s), ref_tipo(s), ref_id(s), id_usuario(i)
  mysqli_stmt_bind_param($st,'ssisssi', $fecha, $tipo, $id_bodega, $motivo, $ref_tipo, $ref_id, $id_usuario);
  if (!mysqli_stmt_execute($st)) throw new Exception('No se pudo crear movimiento');
  $id_mov = (int)mysqli_insert_id($conn);
  mysqli_stmt_close($st);

  // movimiento_det
  $st = mysqli_prepare($conn, "INSERT INTO tb_inv_movimiento_det (id_movimiento, id_accesorio, cantidad, id_ubicacion) VALUES (?,?,?,?)");
  if ($id_ubicacion === null) {
    $null = null;
    mysqli_stmt_bind_param($st,'ii d i', $id_mov, $id_accesorio, $cantidad, $null);
    // Corrige el types:
    mysqli_stmt_close($st);
    $st = mysqli_prepare($conn, "INSERT INTO tb_inv_movimiento_det (id_movimiento, id_accesorio, cantidad, id_ubicacion) VALUES (?,?,?,NULL)");
    mysqli_stmt_bind_param($st,'iid', $id_mov, $id_accesorio, $cantidad);
  } else {
    mysqli_stmt_bind_param($st,'iidi', $id_mov, $id_accesorio, $cantidad, $id_ubicacion);
  }
  if (!mysqli_stmt_execute($st)) throw new Exception('No se pudo crear detalle de movimiento');
  mysqli_stmt_close($st);

  mysqli_commit($conn);
  echo json_encode(['success'=>true,'message'=>'Accesorio ingresado y stock registrado','id_accesorio'=>$id_accesorio,'id_movimiento'=>$id_mov]);
}catch(Throwable $e){
  mysqli_rollback($conn);
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
